/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.shaded.jackson.databind.deser;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.shaded.jackson.annotation.ObjectIdGenerator;
import org.apache.tinkerpop.shaded.jackson.annotation.ObjectIdResolver;
import org.apache.tinkerpop.shaded.jackson.core.JsonParser;
import org.apache.tinkerpop.shaded.jackson.databind.DeserializationConfig;
import org.apache.tinkerpop.shaded.jackson.databind.DeserializationContext;
import org.apache.tinkerpop.shaded.jackson.databind.DeserializationFeature;
import org.apache.tinkerpop.shaded.jackson.databind.InjectableValues;
import org.apache.tinkerpop.shaded.jackson.databind.JsonDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.JsonMappingException;
import org.apache.tinkerpop.shaded.jackson.databind.KeyDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.cfg.HandlerInstantiator;
import org.apache.tinkerpop.shaded.jackson.databind.deser.DeserializerCache;
import org.apache.tinkerpop.shaded.jackson.databind.deser.DeserializerFactory;
import org.apache.tinkerpop.shaded.jackson.databind.deser.ResolvableDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.deser.UnresolvedForwardReference;
import org.apache.tinkerpop.shaded.jackson.databind.deser.impl.ReadableObjectId;
import org.apache.tinkerpop.shaded.jackson.databind.introspect.Annotated;
import org.apache.tinkerpop.shaded.jackson.databind.util.ClassUtil;

public abstract class DefaultDeserializationContext
extends DeserializationContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient LinkedHashMap<ObjectIdGenerator.IdKey, ReadableObjectId> _objectIds;
    private List<ObjectIdResolver> _objectIdResolvers;

    protected DefaultDeserializationContext(DeserializerFactory df, DeserializerCache cache2) {
        super(df, cache2);
    }

    protected DefaultDeserializationContext(DefaultDeserializationContext src, DeserializationConfig config, JsonParser jp, InjectableValues values2) {
        super(src, config, jp, values2);
    }

    protected DefaultDeserializationContext(DefaultDeserializationContext src, DeserializerFactory factory) {
        super(src, factory);
    }

    protected DefaultDeserializationContext(DefaultDeserializationContext src) {
        super(src);
    }

    public DefaultDeserializationContext copy() {
        throw new IllegalStateException("DefaultDeserializationContext sub-class not overriding copy()");
    }

    @Override
    public ReadableObjectId findObjectId(Object id, ObjectIdGenerator<?> gen, ObjectIdResolver resolverType) {
        if (id == null) {
            return null;
        }
        ObjectIdGenerator.IdKey key = gen.key(id);
        if (this._objectIds == null) {
            this._objectIds = new LinkedHashMap();
        } else {
            ReadableObjectId entry2 = this._objectIds.get(key);
            if (entry2 != null) {
                return entry2;
            }
        }
        ObjectIdResolver resolver = null;
        if (this._objectIdResolvers == null) {
            this._objectIdResolvers = new ArrayList<ObjectIdResolver>(8);
        } else {
            for (ObjectIdResolver res : this._objectIdResolvers) {
                if (!res.canUseFor(resolverType)) continue;
                resolver = res;
                break;
            }
        }
        if (resolver == null) {
            resolver = resolverType.newForDeserialization(this);
            this._objectIdResolvers.add(resolver);
        }
        ReadableObjectId entry3 = this.createReadableObjectId(key);
        entry3.setResolver(resolver);
        this._objectIds.put(key, entry3);
        return entry3;
    }

    protected ReadableObjectId createReadableObjectId(ObjectIdGenerator.IdKey key) {
        return new ReadableObjectId(key);
    }

    @Override
    public void checkUnresolvedObjectId() throws UnresolvedForwardReference {
        if (this._objectIds == null) {
            return;
        }
        if (!this.isEnabled(DeserializationFeature.FAIL_ON_UNRESOLVED_OBJECT_IDS)) {
            return;
        }
        UnresolvedForwardReference exception = null;
        for (Map.Entry<ObjectIdGenerator.IdKey, ReadableObjectId> entry2 : this._objectIds.entrySet()) {
            ReadableObjectId roid = entry2.getValue();
            if (!roid.hasReferringProperties() || this.tryToResolveUnresolvedObjectId(roid)) continue;
            if (exception == null) {
                exception = new UnresolvedForwardReference(this.getParser(), "Unresolved forward references for: ");
            }
            Object key = roid.getKey().key;
            Iterator<ReadableObjectId.Referring> iterator2 = roid.referringProperties();
            while (iterator2.hasNext()) {
                ReadableObjectId.Referring referring = iterator2.next();
                exception.addUnresolvedId(key, referring.getBeanType(), referring.getLocation());
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    protected boolean tryToResolveUnresolvedObjectId(ReadableObjectId roid) {
        return roid.tryToResolveUnresolved(this);
    }

    @Override
    public JsonDeserializer<Object> deserializerInstance(Annotated ann, Object deserDef) throws JsonMappingException {
        JsonDeserializer deser;
        if (deserDef == null) {
            return null;
        }
        if (deserDef instanceof JsonDeserializer) {
            deser = (JsonDeserializer)deserDef;
        } else {
            if (!(deserDef instanceof Class)) {
                throw new IllegalStateException("AnnotationIntrospector returned deserializer definition of type " + deserDef.getClass().getName() + "; expected type JsonDeserializer or Class<JsonDeserializer> instead");
            }
            Class deserClass = (Class)deserDef;
            if (deserClass == JsonDeserializer.None.class || ClassUtil.isBogusClass(deserClass)) {
                return null;
            }
            if (!JsonDeserializer.class.isAssignableFrom(deserClass)) {
                throw new IllegalStateException("AnnotationIntrospector returned Class " + deserClass.getName() + "; expected Class<JsonDeserializer>");
            }
            HandlerInstantiator hi2 = this._config.getHandlerInstantiator();
            JsonDeserializer jsonDeserializer = deser = hi2 == null ? null : hi2.deserializerInstance(this._config, ann, deserClass);
            if (deser == null) {
                deser = (JsonDeserializer)ClassUtil.createInstance(deserClass, this._config.canOverrideAccessModifiers());
            }
        }
        if (deser instanceof ResolvableDeserializer) {
            ((ResolvableDeserializer)((Object)deser)).resolve(this);
        }
        return deser;
    }

    @Override
    public final KeyDeserializer keyDeserializerInstance(Annotated ann, Object deserDef) throws JsonMappingException {
        KeyDeserializer deser;
        if (deserDef == null) {
            return null;
        }
        if (deserDef instanceof KeyDeserializer) {
            deser = (KeyDeserializer)deserDef;
        } else {
            if (!(deserDef instanceof Class)) {
                throw new IllegalStateException("AnnotationIntrospector returned key deserializer definition of type " + deserDef.getClass().getName() + "; expected type KeyDeserializer or Class<KeyDeserializer> instead");
            }
            Class deserClass = (Class)deserDef;
            if (deserClass == KeyDeserializer.None.class || ClassUtil.isBogusClass(deserClass)) {
                return null;
            }
            if (!KeyDeserializer.class.isAssignableFrom(deserClass)) {
                throw new IllegalStateException("AnnotationIntrospector returned Class " + deserClass.getName() + "; expected Class<KeyDeserializer>");
            }
            HandlerInstantiator hi2 = this._config.getHandlerInstantiator();
            KeyDeserializer keyDeserializer = deser = hi2 == null ? null : hi2.keyDeserializerInstance(this._config, ann, deserClass);
            if (deser == null) {
                deser = (KeyDeserializer)ClassUtil.createInstance(deserClass, this._config.canOverrideAccessModifiers());
            }
        }
        if (deser instanceof ResolvableDeserializer) {
            ((ResolvableDeserializer)((Object)deser)).resolve(this);
        }
        return deser;
    }

    public abstract DefaultDeserializationContext with(DeserializerFactory var1);

    public abstract DefaultDeserializationContext createInstance(DeserializationConfig var1, JsonParser var2, InjectableValues var3);

    public static final class Impl
    extends DefaultDeserializationContext {
        private static final long serialVersionUID = 1L;

        public Impl(DeserializerFactory df) {
            super(df, null);
        }

        protected Impl(Impl src, DeserializationConfig config, JsonParser jp, InjectableValues values2) {
            super(src, config, jp, values2);
        }

        protected Impl(Impl src) {
            super(src);
        }

        protected Impl(Impl src, DeserializerFactory factory) {
            super(src, factory);
        }

        @Override
        public DefaultDeserializationContext copy() {
            ClassUtil.verifyMustOverride(Impl.class, this, "copy");
            return new Impl(this);
        }

        @Override
        public DefaultDeserializationContext createInstance(DeserializationConfig config, JsonParser p, InjectableValues values2) {
            return new Impl(this, config, p, values2);
        }

        @Override
        public DefaultDeserializationContext with(DeserializerFactory factory) {
            return new Impl(this, factory);
        }
    }
}

