/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.util.iterator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.util.iterator.ArrayIterator;
import org.apache.tinkerpop.gremlin.util.iterator.DoubleIterator;
import org.apache.tinkerpop.gremlin.util.iterator.MultiIterator;
import org.apache.tinkerpop.gremlin.util.iterator.SingleIterator;

public final class IteratorUtils {
    private IteratorUtils() {
    }

    public static final <S> Iterator<S> of(S a) {
        return new SingleIterator<S>(a);
    }

    public static final <S> Iterator<S> of(S a, S b) {
        return new DoubleIterator<S>(a, b);
    }

    public static final <S extends Collection<T>, T> S fill(Iterator<T> iterator2, S collection2) {
        while (iterator2.hasNext()) {
            collection2.add(iterator2.next());
        }
        return collection2;
    }

    public static void iterate(Iterator iterator2) {
        while (iterator2.hasNext()) {
            iterator2.next();
        }
    }

    public static final long count(Iterator iterator2) {
        long ix = 0L;
        while (iterator2.hasNext()) {
            iterator2.next();
            ++ix;
        }
        return ix;
    }

    public static final long count(Iterable iterable) {
        return IteratorUtils.count(iterable.iterator());
    }

    public static <S> List<S> list(Iterator<S> iterator2) {
        return IteratorUtils.fill(iterator2, new ArrayList());
    }

    public static <S> List<S> list(Iterator<S> iterator2, Comparator comparator) {
        List<S> l = IteratorUtils.list(iterator2);
        Collections.sort(l, comparator);
        return l;
    }

    public static <S> Set<S> set(Iterator<S> iterator2) {
        return IteratorUtils.fill(iterator2, new HashSet());
    }

    public static <S> Iterator<S> limit(final Iterator<S> iterator2, final int limit) {
        return new Iterator<S>(){
            private int count = 0;

            @Override
            public boolean hasNext() {
                return iterator2.hasNext() && this.count < limit;
            }

            @Override
            public void remove() {
                iterator2.remove();
            }

            @Override
            public S next() {
                if (this.count++ >= limit) {
                    throw FastNoSuchElementException.instance();
                }
                return iterator2.next();
            }
        };
    }

    public static <T> boolean allMatch(Iterator<T> iterator2, Predicate<T> predicate) {
        while (iterator2.hasNext()) {
            if (predicate.test(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean anyMatch(Iterator<T> iterator2, Predicate<T> predicate) {
        while (iterator2.hasNext()) {
            if (!predicate.test(iterator2.next())) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean noneMatch(Iterator<T> iterator2, Predicate<T> predicate) {
        while (iterator2.hasNext()) {
            if (!predicate.test(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public static <K, S> Map<K, S> collectMap(Iterator<S> iterator2, Function<S, K> key) {
        return IteratorUtils.collectMap(iterator2, key, Function.identity());
    }

    public static <K, S, V> Map<K, V> collectMap(Iterator<S> iterator2, Function<S, K> key, Function<S, V> value2) {
        HashMap<K, V> map2 = new HashMap<K, V>();
        while (iterator2.hasNext()) {
            S obj = iterator2.next();
            map2.put(key.apply(obj), value2.apply(obj));
        }
        return map2;
    }

    public static <K, S> Map<K, List<S>> groupBy(Iterator<S> iterator2, Function<S, K> groupBy2) {
        HashMap<Object, List> map2 = new HashMap<Object, List>();
        while (iterator2.hasNext()) {
            S obj = iterator2.next();
            map2.computeIfAbsent(groupBy2.apply(obj), k -> new ArrayList()).add(obj);
        }
        return map2;
    }

    public static <S> S reduce(Iterator<S> iterator2, S identity, BinaryOperator<S> accumulator) {
        Object result2 = identity;
        while (iterator2.hasNext()) {
            result2 = accumulator.apply(result2, iterator2.next());
        }
        return result2;
    }

    public static <S> S reduce(Iterable<S> iterable, S identity, BinaryOperator<S> accumulator) {
        return IteratorUtils.reduce(iterable.iterator(), identity, accumulator);
    }

    public static <S, E> E reduce(Iterator<S> iterator2, E identity, BiFunction<E, S, E> accumulator) {
        E result2 = identity;
        while (iterator2.hasNext()) {
            result2 = accumulator.apply(result2, iterator2.next());
        }
        return result2;
    }

    public static <S, E> E reduce(Iterable<S> iterable, E identity, BiFunction<E, S, E> accumulator) {
        return IteratorUtils.reduce(iterable.iterator(), identity, accumulator);
    }

    public static final <S> Iterator<S> consume(final Iterator<S> iterator2, final Consumer<S> consumer) {
        return new Iterator<S>(){

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            public void remove() {
                iterator2.remove();
            }

            @Override
            public S next() {
                Object s2 = iterator2.next();
                consumer.accept(s2);
                return s2;
            }
        };
    }

    public static final <S> Iterable<S> consume(Iterable<S> iterable, Consumer<S> consumer) {
        return () -> IteratorUtils.consume(iterable.iterator(), consumer);
    }

    public static final <S, E> Iterator<E> map(final Iterator<S> iterator2, final Function<S, E> function) {
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            public void remove() {
                iterator2.remove();
            }

            @Override
            public E next() {
                return function.apply(iterator2.next());
            }
        };
    }

    public static final <S, E> Iterable<E> map(Iterable<S> iterable, Function<S, E> function) {
        return () -> IteratorUtils.map(iterable.iterator(), function);
    }

    public static final <S> Iterator<S> filter(final Iterator<S> iterator2, final Predicate<S> predicate) {
        return new Iterator<S>(){
            S nextResult = null;

            @Override
            public boolean hasNext() {
                if (null != this.nextResult) {
                    return true;
                }
                this.advance();
                return null != this.nextResult;
            }

            @Override
            public void remove() {
                iterator2.remove();
            }

            @Override
            public S next() {
                try {
                    if (null != this.nextResult) {
                        Object s2 = this.nextResult;
                        return s2;
                    }
                    this.advance();
                    if (null != this.nextResult) {
                        Object s3 = this.nextResult;
                        return s3;
                    }
                    throw FastNoSuchElementException.instance();
                }
                finally {
                    this.nextResult = null;
                }
            }

            private final void advance() {
                this.nextResult = null;
                while (iterator2.hasNext()) {
                    Object s2 = iterator2.next();
                    if (!predicate.test(s2)) continue;
                    this.nextResult = s2;
                    return;
                }
            }
        };
    }

    public static final <S> Iterable<S> filter(Iterable<S> iterable, Predicate<S> predicate) {
        return () -> IteratorUtils.filter(iterable.iterator(), predicate);
    }

    public static final <S, E> Iterator<E> flatMap(final Iterator<S> iterator2, final Function<S, Iterator<E>> function) {
        return new Iterator<E>(){
            private Iterator<E> currentIterator = Collections.emptyIterator();

            @Override
            public boolean hasNext() {
                if (this.currentIterator.hasNext()) {
                    return true;
                }
                while (iterator2.hasNext()) {
                    this.currentIterator = (Iterator)function.apply(iterator2.next());
                    if (!this.currentIterator.hasNext()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void remove() {
                iterator2.remove();
            }

            @Override
            public E next() {
                if (this.hasNext()) {
                    return this.currentIterator.next();
                }
                throw FastNoSuchElementException.instance();
            }
        };
    }

    public static final <S> Iterator<S> concat(Iterator<S> ... iterators) {
        MultiIterator<S> iterator2 = new MultiIterator<S>();
        for (Iterator<S> itty : iterators) {
            iterator2.addIterator(itty);
        }
        return iterator2;
    }

    public static Iterator asIterator(Object o) {
        Iterator<Object> itty = o instanceof Iterable ? ((Iterable)o).iterator() : (o instanceof Iterator ? (ArrayIterator<Object>)o : (o instanceof Object[] ? new ArrayIterator<Object>((Object[])o) : (o instanceof Stream ? ((Stream)o).iterator() : (o instanceof Map ? ((Map)o).entrySet().iterator() : (o instanceof Throwable ? IteratorUtils.of(((Throwable)o).getMessage()) : IteratorUtils.of(o))))));
        return itty;
    }

    public static List asList(Object o) {
        return IteratorUtils.list(IteratorUtils.asIterator(o));
    }

    public static <T> Stream<T> stream(Iterator<T> iterator2) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator2, 1088), false);
    }

    public static <T> Stream<T> stream(Iterable<T> iterable) {
        return IteratorUtils.stream(iterable.iterator());
    }

    public static <T> Iterator<T> noRemove(final Iterator<T> iterator2) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            public void remove() {
            }

            @Override
            public T next() {
                return iterator2.next();
            }
        };
    }

    public static <T> Iterator<T> removeOnNext(final Iterator<T> iterator2) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            public void remove() {
                iterator2.remove();
            }

            @Override
            public T next() {
                Object object = iterator2.next();
                iterator2.remove();
                return object;
            }
        };
    }
}

