/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.structure.io.Storage;

public class TestSupport {
    public static final String TEST_DATA_RELATIVE_DIR = "test-case-data";

    protected TestSupport() {
    }

    public static File makeTestDataPath(Class clazz2, String ... childPath) {
        File root2 = TestSupport.getRootOfBuildDirectory(clazz2);
        List cleanedPaths = Stream.of(childPath).map(TestSupport::cleanPathSegment).collect(Collectors.toList());
        cleanedPaths.add(0, TestSupport.cleanPathSegment(clazz2.getSimpleName()));
        File f2 = new File(new File(root2, TEST_DATA_RELATIVE_DIR), String.join((CharSequence)"/", cleanedPaths));
        if (!f2.exists()) {
            f2.mkdirs();
        }
        return f2;
    }

    public static String makeTestDataDirectory(Class clazz2, String ... childPath) {
        return Storage.toPath(TestSupport.makeTestDataPath(clazz2, childPath));
    }

    public static String makeTestDataFile(Class clazz2, String fileName) {
        return Storage.toPath(new File(TestSupport.makeTestDataPath(clazz2, new String[0]), fileName));
    }

    public static String makeTestDataFile(Class clazz2, String subdir, String fileName) {
        return Storage.toPath(new File(TestSupport.makeTestDataPath(clazz2, subdir), fileName));
    }

    public static File getRootOfBuildDirectory(Class clazz2) {
        File root2;
        String buildDirectory = System.getProperty("build.dir");
        if (null == buildDirectory) {
            String clsUri = clazz2.getName().replace(".", "/") + ".class";
            URL url = clazz2.getClassLoader().getResource(clsUri);
            String clsPath = url.getPath();
            String computePath = clsPath.substring(0, clsPath.length() - clsUri.length());
            root2 = new File(computePath).getParentFile();
        } else {
            root2 = new File(buildDirectory);
        }
        if (!root2.exists()) {
            root2.mkdirs();
        }
        return root2;
    }

    public static File generateTempFile(Class clazz2, String fileName, String fileNameSuffix) throws IOException {
        File path = TestSupport.makeTestDataPath(clazz2, "temp");
        if (!path.exists()) {
            path.mkdirs();
        }
        return File.createTempFile(fileName, fileNameSuffix, path);
    }

    public static File generateTempFileFromResource(Class resourceClass, String resourceName, String extension2) throws IOException {
        return TestSupport.generateTempFileFromResource(resourceClass, resourceClass, resourceName, extension2);
    }

    public static File generateTempFileFromResource(Class graphClass, Class resourceClass, String resourceName, String extension2) throws IOException {
        return TestSupport.generateTempFileFromResource(graphClass, resourceClass, resourceName, extension2, true);
    }

    public static File generateTempFileFromResource(Class graphClass, Class resourceClass, String resourceName, String extension2, boolean overwrite) throws IOException {
        File temp = TestSupport.makeTestDataPath(graphClass, "resources");
        File tempFile = new File(temp, resourceName + extension2);
        if (!tempFile.exists() || overwrite) {
            try (FileOutputStream outputStream = new FileOutputStream(tempFile);
                 InputStream inputStream = resourceClass.getResourceAsStream(resourceName);){
                int data2;
                while ((data2 = inputStream.read()) != -1) {
                    outputStream.write(data2);
                }
            }
        }
        return tempFile;
    }

    public static String cleanPathSegment(String toClean) {
        String cleaned = toClean.replaceAll("[.\\\\/:*?\"<>|\\[\\]\\(\\)]", "");
        if (cleaned.length() == 0) {
            throw new IllegalStateException("Path segment " + toClean + " has not valid characters and is thus empty");
        }
        return cleaned;
    }
}

