/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.function.BiFunction;

public final class NumberHelper {
    static final NumberHelper BYTE_NUMBER_HELPER = new NumberHelper((a, b) -> a.byteValue() + b.byteValue(), (a, b) -> a.byteValue() - b.byteValue(), (a, b) -> a.byteValue() * b.byteValue(), (a, b) -> a.byteValue() / b.byteValue(), (a, b) -> {
        if (NumberHelper.isNumber(a)) {
            if (NumberHelper.isNumber(b)) {
                byte y;
                byte x = a.byteValue();
                return x <= (y = b.byteValue()) ? x : y;
            }
            return a.byteValue();
        }
        return b.byteValue();
    }, (a, b) -> {
        if (NumberHelper.isNumber(a)) {
            if (NumberHelper.isNumber(b)) {
                byte y;
                byte x = a.byteValue();
                return x >= (y = b.byteValue()) ? x : y;
            }
            return a.byteValue();
        }
        return b.byteValue();
    }, (a, b) -> Byte.compare(a.byteValue(), b.byteValue()));
    static final NumberHelper SHORT_NUMBER_HELPER = new NumberHelper((a, b) -> a.shortValue() + b.shortValue(), (a, b) -> a.shortValue() - b.shortValue(), (a, b) -> a.shortValue() * b.shortValue(), (a, b) -> a.shortValue() / b.shortValue(), (a, b) -> {
        if (NumberHelper.isNumber(a)) {
            if (NumberHelper.isNumber(b)) {
                short y;
                short x = a.shortValue();
                return x <= (y = b.shortValue()) ? x : y;
            }
            return a.shortValue();
        }
        return b.shortValue();
    }, (a, b) -> {
        if (NumberHelper.isNumber(a)) {
            if (NumberHelper.isNumber(b)) {
                short y;
                short x = a.shortValue();
                return x >= (y = b.shortValue()) ? x : y;
            }
            return a.shortValue();
        }
        return b.shortValue();
    }, (a, b) -> Short.compare(a.shortValue(), b.shortValue()));
    static final NumberHelper INTEGER_NUMBER_HELPER = new NumberHelper((a, b) -> a.intValue() + b.intValue(), (a, b) -> a.intValue() - b.intValue(), (a, b) -> a.intValue() * b.intValue(), (a, b) -> a.intValue() / b.intValue(), (a, b) -> {
        if (NumberHelper.isNumber(a)) {
            if (NumberHelper.isNumber(b)) {
                int y;
                int x = a.intValue();
                return x <= (y = b.intValue()) ? x : y;
            }
            return a.intValue();
        }
        return b.intValue();
    }, (a, b) -> {
        if (NumberHelper.isNumber(a)) {
            if (NumberHelper.isNumber(b)) {
                int y;
                int x = a.intValue();
                return x >= (y = b.intValue()) ? x : y;
            }
            return a.intValue();
        }
        return b.intValue();
    }, (a, b) -> Integer.compare(a.intValue(), b.intValue()));
    static final NumberHelper LONG_NUMBER_HELPER = new NumberHelper((a, b) -> a.longValue() + b.longValue(), (a, b) -> a.longValue() - b.longValue(), (a, b) -> a.longValue() * b.longValue(), (a, b) -> a.longValue() / b.longValue(), (a, b) -> {
        if (NumberHelper.isNumber(a)) {
            if (NumberHelper.isNumber(b)) {
                long y;
                long x = a.longValue();
                return x <= (y = b.longValue()) ? x : y;
            }
            return a.longValue();
        }
        return b.longValue();
    }, (a, b) -> {
        if (NumberHelper.isNumber(a)) {
            if (NumberHelper.isNumber(b)) {
                long y;
                long x = a.longValue();
                return x >= (y = b.longValue()) ? x : y;
            }
            return a.longValue();
        }
        return b.longValue();
    }, (a, b) -> Long.compare(a.longValue(), b.longValue()));
    static final NumberHelper BIG_INTEGER_NUMBER_HELPER = new NumberHelper((a, b) -> NumberHelper.bigIntegerValue(a).add(NumberHelper.bigIntegerValue(b)), (a, b) -> NumberHelper.bigIntegerValue(a).subtract(NumberHelper.bigIntegerValue(b)), (a, b) -> NumberHelper.bigIntegerValue(a).multiply(NumberHelper.bigIntegerValue(b)), (a, b) -> NumberHelper.bigIntegerValue(a).divide(NumberHelper.bigIntegerValue(b)), (a, b) -> {
        if (NumberHelper.isNumber(a)) {
            if (NumberHelper.isNumber(b)) {
                BigInteger y;
                BigInteger x = NumberHelper.bigIntegerValue(a);
                return x.compareTo(y = NumberHelper.bigIntegerValue(b)) <= 0 ? x : y;
            }
            return NumberHelper.bigIntegerValue(a);
        }
        return NumberHelper.bigIntegerValue(b);
    }, (a, b) -> {
        if (NumberHelper.isNumber(a)) {
            if (NumberHelper.isNumber(b)) {
                BigInteger y;
                BigInteger x = NumberHelper.bigIntegerValue(a);
                return x.compareTo(y = NumberHelper.bigIntegerValue(b)) >= 0 ? x : y;
            }
            return NumberHelper.bigIntegerValue(a);
        }
        return NumberHelper.bigIntegerValue(b);
    }, (a, b) -> NumberHelper.bigIntegerValue(a).compareTo(NumberHelper.bigIntegerValue(b)));
    static final NumberHelper FLOAT_NUMBER_HELPER = new NumberHelper((a, b) -> Float.valueOf(a.floatValue() + b.floatValue()), (a, b) -> Float.valueOf(a.floatValue() - b.floatValue()), (a, b) -> Float.valueOf(a.floatValue() * b.floatValue()), (a, b) -> Float.valueOf(a.floatValue() / b.floatValue()), (a, b) -> {
        if (NumberHelper.isNumber(a)) {
            if (NumberHelper.isNumber(b)) {
                float y;
                float x = a.floatValue();
                return Float.valueOf(x <= (y = b.floatValue()) ? x : y);
            }
            return Float.valueOf(a.floatValue());
        }
        return Float.valueOf(b.floatValue());
    }, (a, b) -> {
        if (NumberHelper.isNumber(a)) {
            if (NumberHelper.isNumber(b)) {
                float y;
                float x = a.floatValue();
                return Float.valueOf(x >= (y = b.floatValue()) ? x : y);
            }
            return Float.valueOf(a.floatValue());
        }
        return Float.valueOf(b.floatValue());
    }, (a, b) -> Float.compare(a.floatValue(), b.floatValue()));
    static final NumberHelper DOUBLE_NUMBER_HELPER = new NumberHelper((a, b) -> a.doubleValue() + b.doubleValue(), (a, b) -> a.doubleValue() - b.doubleValue(), (a, b) -> a.doubleValue() * b.doubleValue(), (a, b) -> a.doubleValue() / b.doubleValue(), (a, b) -> {
        if (NumberHelper.isNumber(a)) {
            if (NumberHelper.isNumber(b)) {
                double y;
                double x = a.doubleValue();
                return x <= (y = b.doubleValue()) ? x : y;
            }
            return a.doubleValue();
        }
        return b.doubleValue();
    }, (a, b) -> {
        if (NumberHelper.isNumber(a)) {
            if (NumberHelper.isNumber(b)) {
                double y;
                double x = a.doubleValue();
                return x >= (y = b.doubleValue()) ? x : y;
            }
            return a.doubleValue();
        }
        return b.doubleValue();
    }, (a, b) -> Double.compare(a.doubleValue(), b.doubleValue()));
    static final NumberHelper BIG_DECIMAL_NUMBER_HELPER = new NumberHelper((a, b) -> NumberHelper.bigDecimalValue(a).add(NumberHelper.bigDecimalValue(b)), (a, b) -> NumberHelper.bigDecimalValue(a).subtract(NumberHelper.bigDecimalValue(b)), (a, b) -> NumberHelper.bigDecimalValue(a).multiply(NumberHelper.bigDecimalValue(b)), (a, b) -> {
        BigDecimal ba = NumberHelper.bigDecimalValue(a);
        BigDecimal bb = NumberHelper.bigDecimalValue(b);
        try {
            return ba.divide(bb);
        }
        catch (ArithmeticException ignored) {
            int precision = Math.max(ba.precision(), bb.precision()) + 10;
            BigDecimal result2 = ba.divide(bb, new MathContext(precision));
            int scale = Math.max(Math.max(ba.scale(), bb.scale()), 10);
            if (result2.scale() > scale) {
                result2 = result2.setScale(scale, 4);
            }
            return result2;
        }
    }, (a, b) -> {
        if (NumberHelper.isNumber(a)) {
            if (NumberHelper.isNumber(b)) {
                BigDecimal y;
                BigDecimal x = NumberHelper.bigDecimalValue(a);
                return x.compareTo(y = NumberHelper.bigDecimalValue(b)) <= 0 ? x : y;
            }
            return NumberHelper.bigDecimalValue(a);
        }
        return NumberHelper.bigDecimalValue(b);
    }, (a, b) -> {
        if (NumberHelper.isNumber(a)) {
            if (NumberHelper.isNumber(b)) {
                BigDecimal y;
                BigDecimal x = NumberHelper.bigDecimalValue(a);
                return x.compareTo(y = NumberHelper.bigDecimalValue(b)) >= 0 ? x : y;
            }
            return NumberHelper.bigDecimalValue(a);
        }
        return NumberHelper.bigDecimalValue(b);
    }, (a, b) -> NumberHelper.bigDecimalValue(a).compareTo(NumberHelper.bigDecimalValue(b)));
    public final BiFunction<Number, Number, Number> add;
    public final BiFunction<Number, Number, Number> sub;
    public final BiFunction<Number, Number, Number> mul;
    public final BiFunction<Number, Number, Number> div;
    public final BiFunction<Number, Number, Number> min;
    public final BiFunction<Number, Number, Number> max;
    public final BiFunction<Number, Number, Integer> cmp;

    private NumberHelper(BiFunction<Number, Number, Number> add2, BiFunction<Number, Number, Number> sub, BiFunction<Number, Number, Number> mul, BiFunction<Number, Number, Number> div2, BiFunction<Number, Number, Number> min2, BiFunction<Number, Number, Number> max2, BiFunction<Number, Number, Integer> cmp) {
        this.add = add2;
        this.sub = sub;
        this.mul = mul;
        this.div = div2;
        this.min = min2;
        this.max = max2;
        this.cmp = cmp;
    }

    public static Class<? extends Number> getHighestCommonNumberClass(Number ... numbers) {
        return NumberHelper.getHighestCommonNumberClass(false, numbers);
    }

    public static Class<? extends Number> getHighestCommonNumberClass(boolean forceFloatingPoint, Number ... numbers) {
        int bits2 = 8;
        boolean fp = forceFloatingPoint;
        for (Number number2 : numbers) {
            Class<?> clazz2;
            if (!NumberHelper.isNumber(number2) || (clazz2 = number2.getClass()).equals(Byte.class)) continue;
            if (clazz2.equals(Short.class)) {
                bits2 = bits2 < 16 ? 16 : bits2;
                continue;
            }
            if (clazz2.equals(Integer.class)) {
                bits2 = bits2 < 32 ? 32 : bits2;
                continue;
            }
            if (clazz2.equals(Long.class)) {
                bits2 = bits2 < 64 ? 64 : bits2;
                continue;
            }
            if (clazz2.equals(BigInteger.class)) {
                bits2 = bits2 < 128 ? 128 : bits2;
                continue;
            }
            if (clazz2.equals(Float.class)) {
                bits2 = bits2 < 32 ? 32 : bits2;
                fp = true;
                continue;
            }
            if (clazz2.equals(Double.class)) {
                bits2 = bits2 < 64 ? 64 : bits2;
                fp = true;
                continue;
            }
            bits2 = bits2 < 128 ? 128 : bits2;
            fp = true;
            break;
        }
        return NumberHelper.determineNumberClass(bits2, fp);
    }

    public static Number add(Number a, Number b) {
        Class<? extends Number> clazz2 = NumberHelper.getHighestCommonNumberClass(a, b);
        return NumberHelper.getHelper(clazz2).add.apply(a, b);
    }

    public static Number sub(Number a, Number b) {
        Class<? extends Number> clazz2 = NumberHelper.getHighestCommonNumberClass(a, b);
        return NumberHelper.getHelper(clazz2).sub.apply(a, b);
    }

    public static Number mul(Number a, Number b) {
        Class<? extends Number> clazz2 = NumberHelper.getHighestCommonNumberClass(a, b);
        return NumberHelper.getHelper(clazz2).mul.apply(a, b);
    }

    public static Number div(Number a, Number b) {
        return NumberHelper.div(a, b, false);
    }

    public static Number div(Number a, Number b, boolean forceFloatingPoint) {
        Class<? extends Number> clazz2 = NumberHelper.getHighestCommonNumberClass(forceFloatingPoint, a, b);
        return NumberHelper.getHelper(clazz2).div.apply(a, b);
    }

    public static Number min(Number a, Number b) {
        Class<? extends Number> clazz2 = NumberHelper.getHighestCommonNumberClass(a, b);
        return NumberHelper.getHelper(clazz2).min.apply(a, b);
    }

    public static Comparable min(Comparable a, Comparable b) {
        if (a instanceof Number && b instanceof Number && !a.equals(Double.NaN) && !b.equals(Double.NaN)) {
            Number an = (Number)((Object)a);
            Number bn = (Number)((Object)b);
            Class<? extends Number> clazz2 = NumberHelper.getHighestCommonNumberClass(an, bn);
            return (Comparable)((Object)NumberHelper.getHelper(clazz2).min.apply(an, bn));
        }
        return NumberHelper.isNonValue(a) ? b : (NumberHelper.isNonValue(b) ? a : (a.compareTo(b) < 0 ? a : b));
    }

    public static Number max(Number a, Number b) {
        Class<? extends Number> clazz2 = NumberHelper.getHighestCommonNumberClass(a, b);
        return NumberHelper.getHelper(clazz2).max.apply(a, b);
    }

    public static Comparable max(Comparable a, Comparable b) {
        if (a instanceof Number && b instanceof Number && !a.equals(Double.NaN) && !b.equals(Double.NaN)) {
            Number an = (Number)((Object)a);
            Number bn = (Number)((Object)b);
            Class<? extends Number> clazz2 = NumberHelper.getHighestCommonNumberClass(an, bn);
            return (Comparable)((Object)NumberHelper.getHelper(clazz2).max.apply(an, bn));
        }
        return NumberHelper.isNonValue(a) ? b : (NumberHelper.isNonValue(b) ? a : (a.compareTo(b) > 0 ? a : b));
    }

    public static Integer compare(Number a, Number b) {
        Class<? extends Number> clazz2 = NumberHelper.getHighestCommonNumberClass(a, b);
        return NumberHelper.getHelper(clazz2).cmp.apply(a, b);
    }

    private static NumberHelper getHelper(Class<? extends Number> clazz2) {
        if (clazz2.equals(Byte.class)) {
            return BYTE_NUMBER_HELPER;
        }
        if (clazz2.equals(Short.class)) {
            return SHORT_NUMBER_HELPER;
        }
        if (clazz2.equals(Integer.class)) {
            return INTEGER_NUMBER_HELPER;
        }
        if (clazz2.equals(Long.class)) {
            return LONG_NUMBER_HELPER;
        }
        if (clazz2.equals(BigInteger.class)) {
            return BIG_INTEGER_NUMBER_HELPER;
        }
        if (clazz2.equals(Float.class)) {
            return FLOAT_NUMBER_HELPER;
        }
        if (clazz2.equals(Double.class)) {
            return DOUBLE_NUMBER_HELPER;
        }
        if (clazz2.equals(BigDecimal.class)) {
            return BIG_DECIMAL_NUMBER_HELPER;
        }
        throw new IllegalArgumentException("Unsupported numeric type: " + clazz2);
    }

    private static BigInteger bigIntegerValue(Number number2) {
        if (number2 == null) {
            return null;
        }
        if (number2 instanceof BigInteger) {
            return (BigInteger)number2;
        }
        return BigInteger.valueOf(number2.longValue());
    }

    private static BigDecimal bigDecimalValue(Number number2) {
        if (number2 == null) {
            return null;
        }
        if (number2 instanceof BigDecimal) {
            return (BigDecimal)number2;
        }
        if (number2 instanceof BigInteger) {
            return new BigDecimal((BigInteger)number2);
        }
        return number2 instanceof Double || number2 instanceof Float ? BigDecimal.valueOf(number2.doubleValue()) : BigDecimal.valueOf(number2.longValue());
    }

    private static Class<? extends Number> determineNumberClass(int bits2, boolean floatingPoint) {
        if (floatingPoint) {
            if (bits2 <= 32) {
                return Float.class;
            }
            if (bits2 <= 64) {
                return Double.class;
            }
            return BigDecimal.class;
        }
        if (bits2 <= 8) {
            return Byte.class;
        }
        if (bits2 <= 16) {
            return Short.class;
        }
        if (bits2 <= 32) {
            return Integer.class;
        }
        if (bits2 <= 64) {
            return Long.class;
        }
        return BigInteger.class;
    }

    private static boolean isNumber(Number number2) {
        return number2 != null && !number2.equals(Double.NaN);
    }

    private static boolean isNonValue(Object value2) {
        return value2 instanceof Double && !NumberHelper.isNumber((Double)value2);
    }
}

