/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.structure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerEdge;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerElement;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerHelper;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerVertexProperty;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public final class TinkerVertex
extends TinkerElement
implements Vertex {
    protected Map<String, List<VertexProperty>> properties;
    protected Map<String, Set<Edge>> outEdges;
    protected Map<String, Set<Edge>> inEdges;
    private final TinkerGraph graph;

    protected TinkerVertex(Object id, String label, TinkerGraph graph) {
        super(id, label);
        this.graph = graph;
    }

    @Override
    public Graph graph() {
        return this.graph;
    }

    @Override
    public <V> VertexProperty<V> property(String key) {
        if (this.removed) {
            return VertexProperty.empty();
        }
        if (TinkerHelper.inComputerMode(this.graph)) {
            List<VertexProperty<?>> list2 = this.graph.graphComputerView.getProperty(this, key);
            if (list2.size() == 0) {
                return VertexProperty.empty();
            }
            if (list2.size() == 1) {
                return list2.get(0);
            }
            throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key);
        }
        if (this.properties != null && this.properties.containsKey(key)) {
            List<VertexProperty> list3 = this.properties.get(key);
            if (list3.size() > 1) {
                throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key);
            }
            return list3.get(0);
        }
        return VertexProperty.empty();
    }

    @Override
    public <V> VertexProperty<V> property(VertexProperty.Cardinality cardinality, String key, V value2, Object ... keyValues) {
        if (this.removed) {
            throw TinkerVertex.elementAlreadyRemoved(Vertex.class, this.id);
        }
        ElementHelper.legalPropertyKeyValueArray(keyValues);
        ElementHelper.validateProperty(key, value2);
        Optional<Object> optionalId = ElementHelper.getIdValue(keyValues);
        Optional<VertexProperty<V>> optionalVertexProperty = ElementHelper.stageVertexProperty(this, cardinality, key, value2, keyValues);
        if (optionalVertexProperty.isPresent()) {
            return optionalVertexProperty.get();
        }
        if (TinkerHelper.inComputerMode(this.graph)) {
            VertexProperty vertexProperty = (VertexProperty)this.graph.graphComputerView.addProperty(this, key, value2);
            ElementHelper.attachProperties(vertexProperty, keyValues);
            return vertexProperty;
        }
        Object idValue = optionalId.isPresent() ? this.graph.vertexPropertyIdManager.convert(optionalId.get()) : this.graph.vertexPropertyIdManager.getNextId(this.graph);
        TinkerVertexProperty<V> vertexProperty = new TinkerVertexProperty<V>(idValue, this, key, value2, new Object[0]);
        if (null == this.properties) {
            this.properties = new HashMap<String, List<VertexProperty>>();
        }
        List list2 = this.properties.getOrDefault(key, new ArrayList());
        list2.add(vertexProperty);
        this.properties.put(key, list2);
        TinkerHelper.autoUpdateIndex(this, key, value2, null);
        ElementHelper.attachProperties(vertexProperty, keyValues);
        return vertexProperty;
    }

    @Override
    public Set<String> keys() {
        if (null == this.properties) {
            return Collections.emptySet();
        }
        return TinkerHelper.inComputerMode((TinkerGraph)this.graph()) ? Vertex.super.keys() : this.properties.keySet();
    }

    @Override
    public Edge addEdge(String label, Vertex vertex, Object ... keyValues) {
        if (null == vertex) {
            throw Graph.Exceptions.argumentCanNotBeNull("vertex");
        }
        if (this.removed) {
            throw TinkerVertex.elementAlreadyRemoved(Vertex.class, this.id);
        }
        return TinkerHelper.addEdge(this.graph, this, (TinkerVertex)vertex, label, keyValues);
    }

    @Override
    public void remove() {
        ArrayList edges2 = new ArrayList();
        this.edges(Direction.BOTH, new String[0]).forEachRemaining(edges2::add);
        edges2.stream().filter(edge -> !((TinkerEdge)edge).removed).forEach(Element::remove);
        this.properties = null;
        TinkerHelper.removeElementIndex(this);
        this.graph.vertices.remove(this.id);
        this.removed = true;
    }

    public String toString() {
        return StringFactory.vertexString(this);
    }

    @Override
    public Iterator<Edge> edges(Direction direction, String ... edgeLabels) {
        Iterator<Edge> edgeIterator = TinkerHelper.getEdges(this, direction, edgeLabels);
        return TinkerHelper.inComputerMode(this.graph) ? IteratorUtils.filter(edgeIterator, edge -> this.graph.graphComputerView.legalEdge(this, (Edge)edge)) : edgeIterator;
    }

    @Override
    public Iterator<Vertex> vertices(Direction direction, String ... edgeLabels) {
        return TinkerHelper.inComputerMode(this.graph) ? (direction.equals((Object)Direction.BOTH) ? IteratorUtils.concat(IteratorUtils.map(this.edges(Direction.OUT, edgeLabels), Edge::inVertex), IteratorUtils.map(this.edges(Direction.IN, edgeLabels), Edge::outVertex)) : IteratorUtils.map(this.edges(direction, edgeLabels), edge -> edge.vertices(direction.opposite()).next())) : TinkerHelper.getVertices(this, direction, edgeLabels);
    }

    @Override
    public <V> Iterator<VertexProperty<V>> properties(String ... propertyKeys) {
        if (this.removed) {
            return Collections.emptyIterator();
        }
        if (TinkerHelper.inComputerMode((TinkerGraph)this.graph())) {
            return ((TinkerGraph)this.graph()).graphComputerView.getProperties(this).stream().filter(p -> ElementHelper.keyExists(p.key(), propertyKeys)).iterator();
        }
        if (null == this.properties) {
            return Collections.emptyIterator();
        }
        if (propertyKeys.length == 1) {
            List properties2 = this.properties.getOrDefault(propertyKeys[0], Collections.emptyList());
            if (properties2.size() == 1) {
                return IteratorUtils.of(properties2.get(0));
            }
            if (properties2.isEmpty()) {
                return Collections.emptyIterator();
            }
            return new ArrayList(properties2).iterator();
        }
        return this.properties.entrySet().stream().filter(entry2 -> ElementHelper.keyExists((String)entry2.getKey(), propertyKeys)).flatMap(entry2 -> ((List)entry2.getValue()).stream()).collect(Collectors.toList()).iterator();
    }
}

