/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.structure;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.io.AbstractIoRegistry;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONIo;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONUtil;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoIo;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoReader;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoWriter;
import org.apache.tinkerpop.gremlin.structure.util.Attachable;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedEdge;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedElement;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertex;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.core.JsonParser;
import org.apache.tinkerpop.shaded.jackson.core.JsonProcessingException;
import org.apache.tinkerpop.shaded.jackson.databind.DeserializationContext;
import org.apache.tinkerpop.shaded.jackson.databind.SerializerProvider;
import org.apache.tinkerpop.shaded.jackson.databind.deser.std.StdDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.module.SimpleModule;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdSerializer;
import org.apache.tinkerpop.shaded.kryo.Kryo;
import org.apache.tinkerpop.shaded.kryo.Serializer;
import org.apache.tinkerpop.shaded.kryo.io.Input;
import org.apache.tinkerpop.shaded.kryo.io.Output;

public final class TinkerIoRegistryV1d0
extends AbstractIoRegistry {
    private static final TinkerIoRegistryV1d0 INSTANCE = new TinkerIoRegistryV1d0();

    private TinkerIoRegistryV1d0() {
        this.register(GryoIo.class, TinkerGraph.class, new TinkerGraphGryoSerializer());
        this.register(GraphSONIo.class, null, new TinkerModule());
    }

    public static TinkerIoRegistryV1d0 instance() {
        return INSTANCE;
    }

    static class TinkerGraphJacksonDeserializer
    extends StdDeserializer<TinkerGraph> {
        public TinkerGraphJacksonDeserializer() {
            super(TinkerGraph.class);
        }

        @Override
        public TinkerGraph deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            DetachedElement detached;
            List edges2;
            List vertices;
            BaseConfiguration conf = new BaseConfiguration();
            conf.setProperty("gremlin.tinkergraph.defaultVertexPropertyCardinality", "list");
            TinkerGraph graph = TinkerGraph.open(conf);
            if (!jsonParser.getCurrentToken().isStructStart()) {
                if (!jsonParser.getCurrentName().equals("vertices")) {
                    throw new IOException(String.format("Expected a '%s' key", "vertices"));
                }
                jsonParser.nextToken();
                vertices = deserializationContext.readValue(jsonParser, ArrayList.class);
                jsonParser.nextToken();
                if (!jsonParser.getCurrentName().equals("edges")) {
                    throw new IOException(String.format("Expected a '%s' key", "edges"));
                }
                jsonParser.nextToken();
                edges2 = deserializationContext.readValue(jsonParser, ArrayList.class);
            } else {
                Map graphData = deserializationContext.readValue(jsonParser, HashMap.class);
                vertices = (List)graphData.get("vertices");
                edges2 = (List)graphData.get("edges");
            }
            for (Map vertexData : vertices) {
                detached = new DetachedVertex(vertexData.get("id"), vertexData.get("label").toString(), (Map)vertexData.get("properties"));
                detached.attach(Attachable.Method.getOrCreate(graph));
            }
            for (Map edgeData : edges2) {
                detached = new DetachedEdge(edgeData.get("id"), edgeData.get("label").toString(), (Map)edgeData.get("properties"), edgeData.get("outV"), edgeData.get("outVLabel").toString(), edgeData.get("inV"), edgeData.get("inVLabel").toString());
                detached.attach(Attachable.Method.getOrCreate(graph));
            }
            return graph;
        }
    }

    static final class TinkerGraphJacksonSerializer
    extends StdSerializer<TinkerGraph> {
        public TinkerGraphJacksonSerializer() {
            super(TinkerGraph.class);
        }

        @Override
        public void serialize(TinkerGraph graph, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeFieldName("vertices");
            jsonGenerator.writeStartArray();
            Iterator<Vertex> vertices = graph.vertices(new Object[0]);
            while (vertices.hasNext()) {
                serializerProvider.defaultSerializeValue(vertices.next(), jsonGenerator);
            }
            jsonGenerator.writeEndArray();
            jsonGenerator.writeFieldName("edges");
            jsonGenerator.writeStartArray();
            Iterator<Edge> edges2 = graph.edges(new Object[0]);
            while (edges2.hasNext()) {
                serializerProvider.defaultSerializeValue(edges2.next(), jsonGenerator);
            }
            jsonGenerator.writeEndArray();
            jsonGenerator.writeEndObject();
        }

        @Override
        public void serializeWithType(TinkerGraph graph, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("@class", TinkerGraph.class.getName());
            jsonGenerator.writeFieldName("vertices");
            jsonGenerator.writeStartArray();
            jsonGenerator.writeString(ArrayList.class.getName());
            jsonGenerator.writeStartArray();
            Iterator<Vertex> vertices = graph.vertices(new Object[0]);
            while (vertices.hasNext()) {
                GraphSONUtil.writeWithType(vertices.next(), jsonGenerator, serializerProvider, typeSerializer);
            }
            jsonGenerator.writeEndArray();
            jsonGenerator.writeEndArray();
            jsonGenerator.writeFieldName("edges");
            jsonGenerator.writeStartArray();
            jsonGenerator.writeString(ArrayList.class.getName());
            jsonGenerator.writeStartArray();
            Iterator<Edge> edges2 = graph.edges(new Object[0]);
            while (edges2.hasNext()) {
                GraphSONUtil.writeWithType(edges2.next(), jsonGenerator, serializerProvider, typeSerializer);
            }
            jsonGenerator.writeEndArray();
            jsonGenerator.writeEndArray();
            jsonGenerator.writeEndObject();
        }
    }

    static final class TinkerModule
    extends SimpleModule {
        public TinkerModule() {
            super("tinkergraph-1.0");
            this.addSerializer(TinkerGraph.class, new TinkerGraphJacksonSerializer());
            this.addDeserializer(TinkerGraph.class, new TinkerGraphJacksonDeserializer());
        }
    }

    static final class TinkerGraphGryoSerializer
    extends Serializer<TinkerGraph> {
        TinkerGraphGryoSerializer() {
        }

        @Override
        public void write(Kryo kryo, Output output, TinkerGraph graph) {
            try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
                GryoWriter.build().mapper(() -> kryo).create().writeGraph(stream, graph);
                byte[] bytes2 = stream.toByteArray();
                output.writeInt(bytes2.length);
                output.write(bytes2);
            }
            catch (Exception io) {
                throw new RuntimeException(io);
            }
        }

        @Override
        public TinkerGraph read(Kryo kryo, Input input2, Class<TinkerGraph> tinkerGraphClass) {
            BaseConfiguration conf = new BaseConfiguration();
            conf.setProperty("gremlin.tinkergraph.defaultVertexPropertyCardinality", "list");
            TinkerGraph graph = TinkerGraph.open(conf);
            int len = input2.readInt();
            byte[] bytes2 = input2.readBytes(len);
            try (ByteArrayInputStream stream = new ByteArrayInputStream(bytes2);){
                GryoReader.build().mapper(() -> kryo).create().readGraph(stream, graph);
            }
            catch (Exception io) {
                throw new RuntimeException(io);
            }
            return graph;
        }
    }
}

