/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.structure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;

final class TinkerIndex<T extends Element> {
    protected Map<String, Map<Object, Set<T>>> index = new ConcurrentHashMap<String, Map<Object, Set<T>>>();
    protected final Class<T> indexClass;
    private final Set<String> indexedKeys = new HashSet<String>();
    private final TinkerGraph graph;

    public TinkerIndex(TinkerGraph graph, Class<T> indexClass) {
        this.graph = graph;
        this.indexClass = indexClass;
    }

    protected void put(String key, Object value2, T element) {
        Set<T> objects;
        Map<Object, Set<T>> keyMap = this.index.get(key);
        if (null == keyMap) {
            this.index.putIfAbsent(key, new ConcurrentHashMap());
            keyMap = this.index.get(key);
        }
        if (null == (objects = keyMap.get(value2))) {
            keyMap.putIfAbsent(value2, ConcurrentHashMap.newKeySet());
            objects = keyMap.get(value2);
        }
        objects.add(element);
    }

    public List<T> get(String key, Object value2) {
        Map<Object, Set<T>> keyMap = this.index.get(key);
        if (null == keyMap) {
            return Collections.emptyList();
        }
        Set<T> set2 = keyMap.get(value2);
        if (null == set2) {
            return Collections.emptyList();
        }
        return new ArrayList<T>(set2);
    }

    public long count(String key, Object value2) {
        Map<Object, Set<T>> keyMap = this.index.get(key);
        if (null == keyMap) {
            return 0L;
        }
        Set<T> set2 = keyMap.get(value2);
        if (null == set2) {
            return 0L;
        }
        return set2.size();
    }

    public void remove(String key, Object value2, T element) {
        Set<T> objects;
        Map<Object, Set<T>> keyMap = this.index.get(key);
        if (null != keyMap && null != (objects = keyMap.get(value2))) {
            objects.remove(element);
            if (objects.size() == 0) {
                keyMap.remove(value2);
            }
        }
    }

    public void removeElement(T element) {
        if (this.indexClass.isAssignableFrom(element.getClass())) {
            for (Map<Object, Set<T>> map2 : this.index.values()) {
                for (Set<T> set2 : map2.values()) {
                    set2.remove(element);
                }
            }
        }
    }

    public void autoUpdate(String key, Object newValue, Object oldValue, T element) {
        if (this.indexedKeys.contains(key)) {
            if (oldValue != null) {
                this.remove(key, oldValue, element);
            }
            this.put(key, newValue, element);
        }
    }

    public void autoRemove(String key, Object oldValue, T element) {
        if (this.indexedKeys.contains(key)) {
            this.remove(key, oldValue, element);
        }
    }

    public void createKeyIndex(String key) {
        if (null == key) {
            throw Graph.Exceptions.argumentCanNotBeNull("key");
        }
        if (key.isEmpty()) {
            throw new IllegalArgumentException("The key for the index cannot be an empty string");
        }
        if (this.indexedKeys.contains(key)) {
            return;
        }
        this.indexedKeys.add(key);
        (Vertex.class.isAssignableFrom(this.indexClass) ? this.graph.vertices.values().parallelStream() : this.graph.edges.values().parallelStream()).map(e -> new Object[]{e.property(key), e}).filter(a -> ((Property)a[0]).isPresent()).forEach(a -> this.put(key, ((Property)a[0]).value(), (Element)a[1]));
    }

    public void dropKeyIndex(String key) {
        if (this.index.containsKey(key)) {
            this.index.remove(key).clear();
        }
        this.indexedKeys.remove(key);
    }

    public Set<String> getIndexedKeys() {
        return this.indexedKeys;
    }
}

