/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.process.computer;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.MemoryComputeKey;
import org.apache.tinkerpop.gremlin.tinkergraph.process.computer.TinkerMemory;

public final class TinkerWorkerMemory
implements Memory.Admin {
    private final TinkerMemory mainMemory;
    private final Map<String, Object> workerMemory = new HashMap<String, Object>();
    private final Map<String, BinaryOperator<Object>> reducers = new HashMap<String, BinaryOperator<Object>>();

    public TinkerWorkerMemory(TinkerMemory mainMemory) {
        this.mainMemory = mainMemory;
        for (MemoryComputeKey key : this.mainMemory.memoryKeys.values()) {
            this.reducers.put(key.getKey(), ((MemoryComputeKey)key.clone()).getReducer());
        }
    }

    @Override
    public Set<String> keys() {
        return this.mainMemory.keys();
    }

    @Override
    public void incrIteration() {
        this.mainMemory.incrIteration();
    }

    @Override
    public void setIteration(int iteration) {
        this.mainMemory.setIteration(iteration);
    }

    @Override
    public int getIteration() {
        return this.mainMemory.getIteration();
    }

    @Override
    public void setRuntime(long runTime) {
        this.mainMemory.setRuntime(runTime);
    }

    @Override
    public long getRuntime() {
        return this.mainMemory.getRuntime();
    }

    @Override
    public boolean isInitialIteration() {
        return this.mainMemory.isInitialIteration();
    }

    @Override
    public <R> R get(String key) throws IllegalArgumentException {
        return this.mainMemory.get(key);
    }

    @Override
    public void set(String key, Object value2) {
        this.mainMemory.set(key, value2);
    }

    @Override
    public void add(String key, Object value2) {
        this.mainMemory.checkKeyValue(key, value2);
        Object v = this.workerMemory.get(key);
        this.workerMemory.put(key, null == v ? value2 : this.reducers.get(key).apply(v, value2));
    }

    public String toString() {
        return this.mainMemory.toString();
    }

    protected void complete() {
        for (Map.Entry<String, Object> entry2 : this.workerMemory.entrySet()) {
            this.mainMemory.add(entry2.getKey(), entry2.getValue());
        }
        this.workerMemory.clear();
    }
}

