/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.process.computer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.tinkerpop.gremlin.process.computer.KeyValue;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;

public final class TinkerReduceEmitter<OK, OV>
implements MapReduce.ReduceEmitter<OK, OV> {
    protected Queue<KeyValue<OK, OV>> reduceQueue = new ConcurrentLinkedQueue<KeyValue<OK, OV>>();

    @Override
    public void emit(OK key, OV value2) {
        this.reduceQueue.add(new KeyValue<OK, OV>(key, value2));
    }

    protected void complete(MapReduce<?, ?, OK, OV, ?> mapReduce) {
        if (mapReduce.getReduceKeySort().isPresent()) {
            Comparator<OK> comparator = mapReduce.getReduceKeySort().get();
            ArrayList<KeyValue<OK, OV>> list2 = new ArrayList<KeyValue<OK, OV>>(this.reduceQueue);
            Collections.sort(list2, Comparator.comparing(KeyValue::getKey, comparator));
            this.reduceQueue.clear();
            this.reduceQueue.addAll(list2);
        }
    }
}

