/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.process.computer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.tinkerpop.gremlin.process.computer.KeyValue;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;

public final class TinkerMapEmitter<K, V>
implements MapReduce.MapEmitter<K, V> {
    public Map<K, Queue<V>> reduceMap;
    public Queue<KeyValue<K, V>> mapQueue;
    private final boolean doReduce;

    public TinkerMapEmitter(boolean doReduce) {
        this.doReduce = doReduce;
        if (this.doReduce) {
            this.reduceMap = new ConcurrentHashMap<K, Queue<V>>();
        } else {
            this.mapQueue = new ConcurrentLinkedQueue<KeyValue<K, V>>();
        }
    }

    @Override
    public void emit(K key, V value2) {
        if (this.doReduce) {
            this.reduceMap.computeIfAbsent(key, k -> new ConcurrentLinkedQueue()).add(value2);
        } else {
            this.mapQueue.add(new KeyValue<K, V>(key, value2));
        }
    }

    protected void complete(MapReduce<K, V, ?, ?, ?> mapReduce) {
        if (!this.doReduce && mapReduce.getMapKeySort().isPresent()) {
            Comparator<K> comparator = mapReduce.getMapKeySort().get();
            ArrayList<KeyValue<K, V>> list2 = new ArrayList<KeyValue<K, V>>(this.mapQueue);
            Collections.sort(list2, Comparator.comparing(KeyValue::getKey, comparator));
            this.mapQueue.clear();
            this.mapQueue.addAll(list2);
        } else if (mapReduce.getMapKeySort().isPresent()) {
            Comparator<K> comparator = mapReduce.getMapKeySort().get();
            ArrayList<Map.Entry<K, Queue<V>>> list3 = new ArrayList<Map.Entry<K, Queue<V>>>();
            list3.addAll(this.reduceMap.entrySet());
            Collections.sort(list3, Comparator.comparing(Map.Entry::getKey, comparator));
            this.reduceMap = new LinkedHashMap<K, Queue<V>>();
            list3.forEach(entry2 -> this.reduceMap.put(entry2.getKey(), entry2.getValue()));
        }
    }
}

