/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.util.star;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.process.computer.GraphFilter;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.InputShim;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.KryoShim;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.OutputShim;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.SerializerShim;
import org.apache.tinkerpop.gremlin.structure.util.star.StarGraph;

public class StarGraphSerializer
implements SerializerShim<StarGraph> {
    private final Direction edgeDirectionToSerialize;
    private GraphFilter graphFilter;
    private static final byte VERSION_1 = -128;

    public StarGraphSerializer(Direction edgeDirectionToSerialize, GraphFilter graphFilter) {
        this.edgeDirectionToSerialize = edgeDirectionToSerialize;
        this.graphFilter = graphFilter;
    }

    @Override
    public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, StarGraph starGraph) {
        output.writeByte((byte)-128);
        kryo.writeObjectOrNull(output, starGraph.edgeProperties, HashMap.class);
        kryo.writeObjectOrNull(output, starGraph.metaProperties, HashMap.class);
        kryo.writeClassAndObject(output, starGraph.starVertex.id);
        kryo.writeObject(output, starGraph.starVertex.label);
        this.writeEdges(kryo, output, starGraph, Direction.IN);
        this.writeEdges(kryo, output, starGraph, Direction.OUT);
        kryo.writeObject(output, null != starGraph.starVertex.vertexProperties);
        if (null != starGraph.starVertex.vertexProperties) {
            kryo.writeObject(output, starGraph.starVertex.vertexProperties.size());
            for (Map.Entry<String, List<VertexProperty>> vertexProperties : starGraph.starVertex.vertexProperties.entrySet()) {
                kryo.writeObject(output, vertexProperties.getKey());
                kryo.writeObject(output, vertexProperties.getValue().size());
                for (VertexProperty vertexProperty : vertexProperties.getValue()) {
                    kryo.writeClassAndObject(output, vertexProperty.id());
                    kryo.writeClassAndObject(output, vertexProperty.value());
                }
            }
        }
    }

    @Override
    public <I extends InputShim> StarGraph read(KryoShim<I, ?> kryo, I input2, Class<StarGraph> clazz2) {
        StarGraph starGraph = StarGraph.open();
        input2.readByte();
        starGraph.edgeProperties = kryo.readObjectOrNull(input2, HashMap.class);
        starGraph.metaProperties = kryo.readObjectOrNull(input2, HashMap.class);
        starGraph.addVertex(T.id, kryo.readClassAndObject(input2), T.label, kryo.readObject(input2, String.class));
        this.readEdges(kryo, input2, starGraph, Direction.IN);
        this.readEdges(kryo, input2, starGraph, Direction.OUT);
        if (kryo.readObject(input2, Boolean.class).booleanValue()) {
            int numberOfUniqueKeys = kryo.readObject(input2, Integer.class);
            for (int i = 0; i < numberOfUniqueKeys; ++i) {
                String vertexPropertyKey = kryo.readObject(input2, String.class);
                int numberOfVertexPropertiesWithKey = kryo.readObject(input2, Integer.class);
                for (int j = 0; j < numberOfVertexPropertiesWithKey; ++j) {
                    Object id = kryo.readClassAndObject(input2);
                    Object value2 = kryo.readClassAndObject(input2);
                    starGraph.starVertex.property(VertexProperty.Cardinality.list, vertexPropertyKey, value2, T.id, id);
                }
            }
        }
        return this.graphFilter.hasFilter() ? (StarGraph)starGraph.applyGraphFilter(this.graphFilter).orElse(null) : starGraph;
    }

    private <O extends OutputShim> void writeEdges(KryoShim<?, O> kryo, O output, StarGraph starGraph, Direction direction) {
        Map<String, List<Edge>> starEdges = direction.equals((Object)Direction.OUT) ? starGraph.starVertex.outEdges : starGraph.starVertex.inEdges;
        boolean writeEdges = null != starEdges && this.edgeDirectionToSerialize != null && (this.edgeDirectionToSerialize == direction || this.edgeDirectionToSerialize == Direction.BOTH);
        kryo.writeObject(output, writeEdges);
        if (writeEdges) {
            kryo.writeObject(output, starEdges.size());
            for (Map.Entry<String, List<Edge>> edges2 : starEdges.entrySet()) {
                kryo.writeObject(output, edges2.getKey());
                kryo.writeObject(output, edges2.getValue().size());
                for (Edge edge : edges2.getValue()) {
                    kryo.writeClassAndObject(output, edge.id());
                    kryo.writeClassAndObject(output, direction.equals((Object)Direction.OUT) ? edge.inVertex().id() : edge.outVertex().id());
                }
            }
        }
    }

    private <I extends InputShim> void readEdges(KryoShim<I, ?> kryo, I input2, StarGraph starGraph, Direction direction) {
        if (kryo.readObject(input2, Boolean.class).booleanValue()) {
            int numberOfUniqueLabels = kryo.readObject(input2, Integer.class);
            for (int i = 0; i < numberOfUniqueLabels; ++i) {
                String edgeLabel = kryo.readObject(input2, String.class);
                int numberOfEdgesWithLabel = kryo.readObject(input2, Integer.class);
                for (int j = 0; j < numberOfEdgesWithLabel; ++j) {
                    Object edgeId = kryo.readClassAndObject(input2);
                    Object adjacentVertexId = kryo.readClassAndObject(input2);
                    if (this.graphFilter.checkEdgeLegality(direction, edgeLabel).positive()) {
                        if (direction.equals((Object)Direction.OUT)) {
                            starGraph.starVertex.addOutEdge(edgeLabel, starGraph.addVertex(T.id, adjacentVertexId), T.id, edgeId);
                            continue;
                        }
                        starGraph.starVertex.addInEdge(edgeLabel, starGraph.addVertex(T.id, adjacentVertexId), T.id, edgeId);
                        continue;
                    }
                    if (null == starGraph.edgeProperties) continue;
                    starGraph.edgeProperties.remove(edgeId);
                }
            }
        }
    }
}

