/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.util.reference;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.BulkSet;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Tree;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceEdge;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceElement;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferencePath;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceProperty;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceVertex;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceVertexProperty;

public class ReferenceFactory {
    private ReferenceFactory() {
    }

    public static ReferenceVertex detach(Vertex vertex) {
        return vertex instanceof ReferenceVertex ? (ReferenceVertex)vertex : new ReferenceVertex(vertex);
    }

    public static ReferenceEdge detach(Edge edge) {
        return edge instanceof ReferenceEdge ? (ReferenceEdge)edge : new ReferenceEdge(edge);
    }

    public static <V> ReferenceVertexProperty detach(VertexProperty<V> vertexProperty) {
        return vertexProperty instanceof ReferenceVertexProperty ? (ReferenceVertexProperty)vertexProperty : new ReferenceVertexProperty<V>(vertexProperty);
    }

    public static <V> ReferenceProperty<V> detach(Property<V> property) {
        return property instanceof ReferenceProperty ? (ReferenceProperty)property : new ReferenceProperty<V>(property);
    }

    public static ReferencePath detach(Path path) {
        return path instanceof ReferencePath ? (ReferencePath)path : new ReferencePath(path);
    }

    public static ReferenceElement detach(Element element) {
        if (element instanceof Vertex) {
            return ReferenceFactory.detach((Vertex)element);
        }
        if (element instanceof Edge) {
            return ReferenceFactory.detach((Edge)element);
        }
        if (element instanceof VertexProperty) {
            return ReferenceFactory.detach((VertexProperty)element);
        }
        throw new IllegalArgumentException("The provided argument is an unknown element: " + element + ':' + element.getClass());
    }

    public static <D> D detach(Object object) {
        if (object instanceof Element) {
            return (D)ReferenceFactory.detach((Element)object);
        }
        if (object instanceof Property) {
            return (D)ReferenceFactory.detach((Property)object);
        }
        if (object instanceof Path) {
            return (D)ReferenceFactory.detach((Path)object);
        }
        if (object instanceof List) {
            ArrayList<D> list2 = new ArrayList<D>(((List)object).size());
            for (Object item : (List)object) {
                list2.add(ReferenceFactory.detach(item));
            }
            return (D)list2;
        }
        if (object instanceof BulkSet) {
            BulkSet<D> set2 = new BulkSet<D>();
            for (Map.Entry entry2 : ((BulkSet)object).asBulk().entrySet()) {
                set2.add(ReferenceFactory.detach(entry2.getKey()), entry2.getValue());
            }
            return (D)set2;
        }
        if (object instanceof Set) {
            HashSet set3 = object instanceof LinkedHashSet ? new LinkedHashSet(((Set)object).size()) : new HashSet(((Set)object).size());
            for (Object item : (Set)object) {
                set3.add(ReferenceFactory.detach(item));
            }
            return (D)set3;
        }
        if (object instanceof Map) {
            Tree map2 = object instanceof Tree ? new Tree() : (object instanceof LinkedHashMap ? new LinkedHashMap(((Map)object).size()) : new HashMap(((Map)object).size()));
            for (Map.Entry entry3 : ((Map)object).entrySet()) {
                map2.put(ReferenceFactory.detach(entry3.getKey()), ReferenceFactory.detach(entry3.getValue()));
            }
            return (D)map2;
        }
        return (D)object;
    }
}

