/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.util.detached;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedElement;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedFactory;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedProperty;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertex;

public class DetachedVertexProperty<V>
extends DetachedElement<VertexProperty<V>>
implements VertexProperty<V> {
    protected V value;
    protected transient DetachedVertex vertex;

    private DetachedVertexProperty() {
    }

    protected DetachedVertexProperty(VertexProperty<V> vertexProperty, boolean withProperties) {
        super(vertexProperty);
        Iterator propertyIterator;
        this.value = vertexProperty.value();
        this.vertex = DetachedFactory.detach(vertexProperty.element(), false);
        if (withProperties && vertexProperty.graph().features().vertex().supportsMetaProperties() && (propertyIterator = vertexProperty.properties(new String[0])).hasNext()) {
            this.properties = new HashMap();
            propertyIterator.forEachRemaining(property -> this.properties.put(property.key(), Collections.singletonList(DetachedFactory.detach(property))));
        }
    }

    public DetachedVertexProperty(Object id, String label, V value2, Map<String, Object> properties2, Vertex vertex) {
        super(id, label);
        this.value = value2;
        this.vertex = DetachedFactory.detach(vertex, true);
        if (null != properties2 && !properties2.isEmpty()) {
            this.properties = new HashMap();
            properties2.entrySet().iterator().forEachRemaining(entry2 -> this.properties.put(entry2.getKey(), Collections.singletonList(new DetachedProperty((String)entry2.getKey(), entry2.getValue(), this))));
        }
    }

    public DetachedVertexProperty(Object id, String label, V value2, Map<String, Object> properties2) {
        super(id, label);
        this.value = value2;
        if (null != properties2 && !properties2.isEmpty()) {
            this.properties = new HashMap();
            properties2.entrySet().iterator().forEachRemaining(entry2 -> this.properties.put(entry2.getKey(), Collections.singletonList(new DetachedProperty((String)entry2.getKey(), entry2.getValue(), this))));
        }
    }

    @Override
    public boolean isPresent() {
        return true;
    }

    @Override
    public String key() {
        return this.label;
    }

    @Override
    public V value() {
        return this.value;
    }

    @Override
    public Vertex element() {
        return this.vertex;
    }

    @Override
    public void remove() {
        throw Property.Exceptions.propertyRemovalNotSupported();
    }

    public String toString() {
        return StringFactory.propertyString(this);
    }

    @Override
    public boolean equals(Object object) {
        return ElementHelper.areEqual((VertexProperty)this, object);
    }

    @Override
    public <U> Iterator<Property<U>> properties(String ... propertyKeys) {
        return super.properties(propertyKeys);
    }

    @Override
    void internalAddProperty(Property p) {
        if (null == this.properties) {
            this.properties = new HashMap();
        }
        this.properties.put(p.key(), Collections.singletonList(p));
    }

    public void internalSetVertex(DetachedVertex vertex) {
        this.vertex = vertex;
    }

    public static Builder build() {
        return new Builder(new DetachedVertexProperty());
    }

    public static class Builder {
        private DetachedVertexProperty vp;

        private Builder(DetachedVertexProperty e) {
            this.vp = e;
        }

        public Builder setV(DetachedVertex v) {
            this.vp.internalSetVertex(v);
            return this;
        }

        public Builder addProperty(Property p) {
            this.vp.internalAddProperty(p);
            return this;
        }

        public Builder setId(Object id) {
            this.vp.id = id;
            return this;
        }

        public Builder setLabel(String label) {
            this.vp.label = label;
            return this;
        }

        public Builder setValue(Object value2) {
            this.vp.value = value2;
            return this;
        }

        public DetachedVertexProperty create() {
            return this.vp;
        }
    }
}

