/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.util.detached;

import java.io.Serializable;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.util.Attachable;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedElement;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedFactory;

public class DetachedProperty<V>
implements Property<V>,
Serializable,
Attachable<Property<V>> {
    private String key;
    private V value;
    private transient DetachedElement element;

    private DetachedProperty() {
    }

    protected DetachedProperty(Property<V> property) {
        this.key = property.key();
        this.value = property.value();
        this.element = DetachedFactory.detach(property.element(), false);
    }

    public DetachedProperty(String key, V value2) {
        this.key = key;
        this.value = value2;
        this.element = null;
    }

    public DetachedProperty(String key, V value2, Element element) {
        this.key = key;
        this.value = value2;
        this.element = DetachedFactory.detach(element, false);
    }

    @Override
    public Property<V> get() {
        return this;
    }

    @Override
    public boolean isPresent() {
        return true;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public V value() {
        return this.value;
    }

    @Override
    public Element element() {
        return this.element;
    }

    @Override
    public void remove() {
        throw Property.Exceptions.propertyRemovalNotSupported();
    }

    public String toString() {
        return StringFactory.propertyString(this);
    }

    public boolean equals(Object object) {
        return ElementHelper.areEqual(this, object);
    }

    public int hashCode() {
        return ElementHelper.hashCode(this);
    }
}

