/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.util.detached;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.BulkSet;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Tree;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedEdge;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedElement;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedPath;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedProperty;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertex;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertexProperty;

public class DetachedFactory {
    private DetachedFactory() {
    }

    public static DetachedVertex detach(Vertex vertex, boolean withProperties) {
        return vertex instanceof DetachedVertex ? (DetachedVertex)vertex : new DetachedVertex(vertex, withProperties);
    }

    public static DetachedEdge detach(Edge edge, boolean withProperties) {
        return edge instanceof DetachedEdge ? (DetachedEdge)edge : new DetachedEdge(edge, withProperties);
    }

    public static <V> DetachedVertexProperty detach(VertexProperty<V> vertexProperty, boolean withProperties) {
        return vertexProperty instanceof DetachedVertexProperty ? (DetachedVertexProperty)vertexProperty : new DetachedVertexProperty<V>(vertexProperty, withProperties);
    }

    public static <V> DetachedProperty<V> detach(Property<V> property) {
        return property instanceof DetachedProperty ? (DetachedProperty)property : new DetachedProperty<V>(property);
    }

    public static DetachedPath detach(Path path, boolean withProperties) {
        return path instanceof DetachedPath ? (DetachedPath)path : new DetachedPath(path, withProperties);
    }

    public static DetachedElement detach(Element element, boolean withProperties) {
        if (element instanceof Vertex) {
            return DetachedFactory.detach((Vertex)element, withProperties);
        }
        if (element instanceof Edge) {
            return DetachedFactory.detach((Edge)element, withProperties);
        }
        if (element instanceof VertexProperty) {
            return DetachedFactory.detach((VertexProperty)element, withProperties);
        }
        throw new IllegalArgumentException("The provided argument is an unknown element: " + element + ':' + element.getClass());
    }

    public static <D> D detach(Object object, boolean withProperties) {
        if (object instanceof Element) {
            return (D)DetachedFactory.detach((Element)object, withProperties);
        }
        if (object instanceof Property) {
            return (D)DetachedFactory.detach((Property)object);
        }
        if (object instanceof Path) {
            return (D)DetachedFactory.detach((Path)object, withProperties);
        }
        if (object instanceof List) {
            ArrayList<D> list2 = new ArrayList<D>(((List)object).size());
            for (Object item : (List)object) {
                list2.add(DetachedFactory.detach(item, withProperties));
            }
            return (D)list2;
        }
        if (object instanceof BulkSet) {
            BulkSet<D> set2 = new BulkSet<D>();
            for (Map.Entry entry2 : ((BulkSet)object).asBulk().entrySet()) {
                set2.add(DetachedFactory.detach(entry2.getKey(), withProperties), entry2.getValue());
            }
            return (D)set2;
        }
        if (object instanceof Set) {
            HashSet set3 = object instanceof LinkedHashSet ? new LinkedHashSet(((Set)object).size()) : new HashSet(((Set)object).size());
            for (Object item : (Set)object) {
                set3.add(DetachedFactory.detach(item, withProperties));
            }
            return (D)set3;
        }
        if (object instanceof Map) {
            Tree map2 = object instanceof Tree ? new Tree() : (object instanceof LinkedHashMap ? new LinkedHashMap(((Map)object).size()) : new HashMap(((Map)object).size()));
            for (Map.Entry entry3 : ((Map)object).entrySet()) {
                map2.put(DetachedFactory.detach(entry3.getKey(), withProperties), DetachedFactory.detach(entry3.getValue(), withProperties));
            }
            return (D)map2;
        }
        return (D)object;
    }
}

