/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.util;

import java.io.File;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.util.GraphFactoryClass;
import org.apache.tinkerpop.gremlin.util.config.YamlConfiguration;

public final class GraphFactory {
    private GraphFactory() {
    }

    public static Graph open(Configuration configuration) {
        Class<?> graphClass;
        if (null == configuration) {
            throw Graph.Exceptions.argumentCanNotBeNull("configuration");
        }
        String clazz2 = configuration.getString("gremlin.graph", null);
        if (null == clazz2) {
            throw new RuntimeException(String.format("Configuration must contain a valid '%s' setting", "gremlin.graph"));
        }
        try {
            graphClass = Class.forName(clazz2);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(String.format("GraphFactory could not find [%s] - Ensure that the jar is in the classpath", clazz2));
        }
        GraphFactoryClass factoryAnnotation = graphClass.getAnnotation(GraphFactoryClass.class);
        Class<?> factoryClass = factoryAnnotation != null ? factoryAnnotation.value() : graphClass;
        return GraphFactory.open(configuration, factoryClass);
    }

    private static Graph open(Configuration configuration, Class<?> graphFactoryClass) {
        Graph g;
        try {
            g = (Graph)graphFactoryClass.getMethod("open", Configuration.class).invoke(null, configuration);
        }
        catch (NoSuchMethodException e1) {
            throw new RuntimeException(String.format("GraphFactory can only instantiate Graph implementations from classes that have a static open() method that takes a single Apache Commons Configuration argument - [%s] does not seem to have one", graphFactoryClass));
        }
        catch (Exception e2) {
            throw new RuntimeException(String.format("GraphFactory could not instantiate this Graph implementation [%s]", graphFactoryClass), e2);
        }
        return g;
    }

    public static Graph open(String configurationFile) {
        if (null == configurationFile) {
            throw Graph.Exceptions.argumentCanNotBeNull("configurationFile");
        }
        return GraphFactory.open(GraphFactory.getConfiguration(new File(configurationFile)));
    }

    public static Graph open(Map configuration) {
        if (null == configuration) {
            throw Graph.Exceptions.argumentCanNotBeNull("configuration");
        }
        return GraphFactory.open(new MapConfiguration(configuration));
    }

    private static Configuration getConfiguration(File configurationFile) {
        if (!configurationFile.isFile()) {
            throw new IllegalArgumentException(String.format("The location configuration must resolve to a file and [%s] does not", configurationFile));
        }
        try {
            String fileExtension;
            String fileName = configurationFile.getName();
            switch (fileExtension = fileName.substring(fileName.lastIndexOf(46) + 1)) {
                case "yml": 
                case "yaml": {
                    YamlConfiguration config = new YamlConfiguration();
                    config.load(configurationFile);
                    return config;
                }
                case "xml": {
                    return new XMLConfiguration(configurationFile);
                }
            }
            return new PropertiesConfiguration(configurationFile);
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException(String.format("Could not load configuration at: %s", configurationFile), e);
        }
    }
}

