/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.gryo;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;

public final class VertexByteArrayInputStream
extends FilterInputStream {
    private static final byte[] vertexTerminatorClass = new byte[]{15, 1, 1, 9};
    private static final byte[] pattern = ByteBuffer.allocate(vertexTerminatorClass.length + 8).put(vertexTerminatorClass).putLong(4185403236219066774L).array();

    public VertexByteArrayInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public ByteArrayOutputStream readVertexBytes() throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        LinkedList<Byte> buffer = new LinkedList<Byte>();
        int current = this.read();
        while (!(current <= -1 || buffer.size() >= 12 && VertexByteArrayInputStream.isMatch(buffer))) {
            stream.write(current);
            current = this.read();
            if (buffer.size() > 11) {
                buffer.removeFirst();
            }
            buffer.addLast((byte)current);
        }
        stream.write(current);
        return stream;
    }

    private static boolean isMatch(List<Byte> input2) {
        for (int i = 0; i < pattern.length; ++i) {
            if (pattern[i] == input2.get(i)) continue;
            return false;
        }
        return true;
    }
}

