/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.gryo;

import java.net.InetAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.InputShim;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.KryoShim;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.OutputShim;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.SerializerShim;
import org.apache.tinkerpop.gremlin.util.function.HashSetSupplier;
import org.apache.tinkerpop.shaded.kryo.Kryo;
import org.apache.tinkerpop.shaded.kryo.Serializer;
import org.apache.tinkerpop.shaded.kryo.io.Input;
import org.apache.tinkerpop.shaded.kryo.io.Output;
import org.javatuples.Pair;
import org.javatuples.Triplet;

final class UtilSerializers {
    private UtilSerializers() {
    }

    static final class SynchronizedMapSerializer
    implements SerializerShim<Map> {
        SynchronizedMapSerializer() {
        }

        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, Map map2) {
            LinkedHashMap m = new LinkedHashMap();
            map2.forEach(m::put);
            kryo.writeObject(output, m);
        }

        @Override
        public <I extends InputShim> Map read(KryoShim<I, ?> kryo, I input2, Class<Map> clazz2) {
            return Collections.synchronizedMap(kryo.readObject(input2, LinkedHashMap.class));
        }
    }

    static final class EntrySerializer
    extends Serializer<Map.Entry> {
        EntrySerializer() {
        }

        @Override
        public void write(Kryo kryo, Output output, Map.Entry entry2) {
            kryo.writeClassAndObject(output, entry2.getKey());
            kryo.writeClassAndObject(output, entry2.getValue());
        }

        @Override
        public Map.Entry read(Kryo kryo, Input input2, Class<Map.Entry> entryClass) {
            return new AbstractMap.SimpleEntry<Object, Object>(kryo.readClassAndObject(input2), kryo.readClassAndObject(input2));
        }
    }

    static final class TripletSerializer
    implements SerializerShim<Triplet> {
        TripletSerializer() {
        }

        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, Triplet triplet) {
            kryo.writeClassAndObject(output, triplet.getValue0());
            kryo.writeClassAndObject(output, triplet.getValue1());
            kryo.writeClassAndObject(output, triplet.getValue2());
        }

        @Override
        public <I extends InputShim> Triplet read(KryoShim<I, ?> kryo, I input2, Class<Triplet> tripletClass) {
            return Triplet.with(kryo.readClassAndObject(input2), kryo.readClassAndObject(input2), kryo.readClassAndObject(input2));
        }
    }

    static final class PairSerializer
    implements SerializerShim<Pair> {
        PairSerializer() {
        }

        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, Pair pair2) {
            kryo.writeClassAndObject(output, pair2.getValue0());
            kryo.writeClassAndObject(output, pair2.getValue1());
        }

        @Override
        public <I extends InputShim> Pair read(KryoShim<I, ?> kryo, I input2, Class<Pair> pairClass) {
            return Pair.with(kryo.readClassAndObject(input2), kryo.readClassAndObject(input2));
        }
    }

    static final class URISerializer
    implements SerializerShim<URI> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, URI uri2) {
            output.writeString(uri2.toString());
        }

        @Override
        public <I extends InputShim> URI read(KryoShim<I, ?> kryo, I input2, Class<URI> uriClass) {
            return URI.create(input2.readString());
        }

        @Override
        public boolean isImmutable() {
            return true;
        }
    }

    static final class UUIDSerializer
    implements SerializerShim<UUID> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, UUID uuid) {
            output.writeLong(uuid.getMostSignificantBits());
            output.writeLong(uuid.getLeastSignificantBits());
        }

        @Override
        public <I extends InputShim> UUID read(KryoShim<I, ?> kryo, I input2, Class<UUID> uuidClass) {
            return new UUID(input2.readLong(), input2.readLong());
        }

        @Override
        public boolean isImmutable() {
            return true;
        }
    }

    public static final class HashSetSupplierSerializer
    implements SerializerShim<HashSetSupplier> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, HashSetSupplier hashSetSupplier) {
        }

        @Override
        public <I extends InputShim> HashSetSupplier read(KryoShim<I, ?> kryo, I input2, Class<HashSetSupplier> clazz2) {
            return HashSetSupplier.instance();
        }
    }

    public static final class InetAddressSerializer
    implements SerializerShim<InetAddress> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, InetAddress addy) {
            String str = addy.toString().trim();
            int slash = str.indexOf(47);
            if (slash >= 0) {
                if (slash == 0) {
                    output.writeString(str.substring(1));
                } else {
                    output.writeString(str.substring(0, slash));
                }
            }
        }

        @Override
        public <I extends InputShim> InetAddress read(KryoShim<I, ?> kryo, I input2, Class<InetAddress> clazz2) {
            try {
                return InetAddress.getByName(input2.readString());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static final class ClassArraySerializer
    implements SerializerShim<Class[]> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, Class[] object) {
            output.writeInt(object.length);
            for (Class clazz2 : object) {
                output.writeString(clazz2.getName());
            }
        }

        @Override
        public <I extends InputShim> Class[] read(KryoShim<I, ?> kryo, I input2, Class<Class[]> clazz2) {
            int size2 = input2.readInt();
            Class[] clazzes = new Class[size2];
            for (int i = 0; i < size2; ++i) {
                try {
                    clazzes[i] = Class.forName(input2.readString());
                    continue;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            return clazzes;
        }
    }

    public static final class ClassSerializer
    implements SerializerShim<Class> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, Class object) {
            output.writeString(object.getName());
        }

        @Override
        public <I extends InputShim> Class read(KryoShim<I, ?> kryo, I input2, Class<Class> clazz2) {
            String name2 = input2.readString();
            try {
                return Class.forName(name2);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static final class ByteBufferSerializer
    implements SerializerShim<ByteBuffer> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, ByteBuffer bb) {
            byte[] b = bb.array();
            int arrayOffset = bb.arrayOffset();
            Arrays.copyOfRange(b, arrayOffset + bb.position(), arrayOffset + bb.limit());
            output.writeInt(b.length);
            output.writeBytes(b, 0, b.length);
        }

        @Override
        public <I extends InputShim> ByteBuffer read(KryoShim<I, ?> kryo, I input2, Class<ByteBuffer> clazz2) {
            int len = input2.readInt();
            byte[] b = input2.readBytes(len);
            ByteBuffer bb = ByteBuffer.allocate(len);
            bb.put(b);
            return bb;
        }
    }

    public static final class ArraysAsListSerializer
    implements SerializerShim<List> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, List list2) {
            ArrayList l = new ArrayList(list2);
            kryo.writeObject(output, l);
        }

        @Override
        public <I extends InputShim> List read(KryoShim<I, ?> kryo, I input2, Class<List> clazz2) {
            return kryo.readObject(input2, ArrayList.class);
        }
    }
}

