/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.gryo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.tinkerpop.gremlin.process.remote.traversal.DefaultRemoteTraverser;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.TextP;
import org.apache.tinkerpop.gremlin.process.traversal.util.AndP;
import org.apache.tinkerpop.gremlin.process.traversal.util.ConnectiveP;
import org.apache.tinkerpop.gremlin.process.traversal.util.DefaultTraversalMetrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.Metrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.MutableMetrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.OrP;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalMetrics;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.InputShim;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.KryoShim;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.OutputShim;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.SerializerShim;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedEdge;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedFactory;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedProperty;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertex;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertexProperty;
import org.apache.tinkerpop.gremlin.util.function.Lambda;

public final class GryoSerializersV3d0 {
    private static void writeElementProperties(KryoShim kryo, OutputShim output, Element element) {
        Iterator properties2 = element.properties(new String[0]);
        output.writeBoolean(properties2.hasNext());
        while (properties2.hasNext()) {
            Property p = properties2.next();
            output.writeString(p.key());
            kryo.writeClassAndObject(output, p.value());
            output.writeBoolean(properties2.hasNext());
        }
    }

    public static final class MetricsSerializer
    implements SerializerShim<Metrics> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, Metrics object) {
            output.writeString(object.getId());
            output.writeString(object.getName());
            output.writeDouble((double)object.getDuration(TimeUnit.NANOSECONDS) / 1000000.0);
            kryo.writeObject(output, object.getCounts());
            LinkedHashMap annotations2 = new LinkedHashMap();
            object.getAnnotations().forEach(annotations2::put);
            kryo.writeObject(output, annotations2);
            ArrayList<? extends Metrics> nested2 = new ArrayList<Metrics>(object.getNested());
            kryo.writeObject(output, nested2);
        }

        @Override
        public <I extends InputShim> Metrics read(KryoShim<I, ?> kryo, I input2, Class<Metrics> clazz2) {
            MutableMetrics m = new MutableMetrics(input2.readString(), input2.readString());
            m.setDuration(Math.round(input2.readDouble() * 1000000.0), TimeUnit.NANOSECONDS);
            Map counts = kryo.readObject(input2, HashMap.class);
            for (Map.Entry entry2 : counts.entrySet()) {
                m.setCount((String)entry2.getKey(), (Long)entry2.getValue());
            }
            Map annotations2 = kryo.readObject(input2, HashMap.class);
            for (Map.Entry entry3 : annotations2.entrySet()) {
                m.setAnnotation((String)entry3.getKey(), entry3.getValue());
            }
            List list2 = kryo.readObject(input2, ArrayList.class);
            for (MutableMetrics nested2 : list2) {
                m.addNested(nested2);
            }
            return m;
        }
    }

    public static final class TraversalMetricsSerializer
    implements SerializerShim<TraversalMetrics> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, TraversalMetrics object) {
            output.writeDouble((double)object.getDuration(TimeUnit.NANOSECONDS) / 1000000.0);
            Collection<? extends Metrics> metrics = object.getMetrics();
            output.writeInt(metrics.size());
            metrics.forEach(m -> kryo.writeObject(output, m));
        }

        @Override
        public <I extends InputShim> TraversalMetrics read(KryoShim<I, ?> kryo, I input2, Class<TraversalMetrics> clazz2) {
            double duration = input2.readDouble();
            int size2 = input2.readInt();
            ArrayList<MutableMetrics> orderedMetrics = new ArrayList<MutableMetrics>();
            for (int ix = 0; ix < size2; ++ix) {
                orderedMetrics.add(kryo.readObject(input2, MutableMetrics.class));
            }
            return new DefaultTraversalMetrics(Math.round(duration * 1000000.0), orderedMetrics);
        }
    }

    public static final class DefaultRemoteTraverserSerializer
    implements SerializerShim<DefaultRemoteTraverser> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, DefaultRemoteTraverser remoteTraverser) {
            kryo.writeClassAndObject(output, remoteTraverser.get());
            output.writeLong(remoteTraverser.bulk());
        }

        @Override
        public <I extends InputShim> DefaultRemoteTraverser read(KryoShim<I, ?> kryo, I input2, Class<DefaultRemoteTraverser> remoteTraverserClass) {
            Object o = kryo.readClassAndObject(input2);
            return new DefaultRemoteTraverser<Object>(o, input2.readLong());
        }
    }

    public static final class BindingSerializer
    implements SerializerShim<Bytecode.Binding> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, Bytecode.Binding binding) {
            output.writeString(binding.variable());
            kryo.writeClassAndObject(output, binding.value());
        }

        @Override
        public <I extends InputShim> Bytecode.Binding read(KryoShim<I, ?> kryo, I input2, Class<Bytecode.Binding> clazz2) {
            String var = input2.readString();
            Object val = kryo.readClassAndObject(input2);
            return new Bytecode.Binding<Object>(var, val);
        }
    }

    public static final class LambdaSerializer
    implements SerializerShim<Lambda> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, Lambda lambda) {
            output.writeString(lambda.getLambdaScript());
            output.writeString(lambda.getLambdaLanguage());
            output.writeInt(lambda.getLambdaArguments());
        }

        @Override
        public <I extends InputShim> Lambda read(KryoShim<I, ?> kryo, I input2, Class<Lambda> clazz2) {
            String script = input2.readString();
            String language2 = input2.readString();
            int arguments = input2.readInt();
            if (-1 == arguments || arguments > 2) {
                return new Lambda.UnknownArgLambda(script, language2, arguments);
            }
            if (0 == arguments) {
                return new Lambda.ZeroArgLambda(script, language2);
            }
            if (1 == arguments) {
                return new Lambda.OneArgLambda(script, language2);
            }
            return new Lambda.TwoArgLambda(script, language2);
        }
    }

    public static final class TextPSerializer
    implements SerializerShim<TextP> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, TextP p) {
            output.writeString(p.getBiPredicate().toString());
            kryo.writeObject(output, p.getValue());
        }

        @Override
        public <I extends InputShim> TextP read(KryoShim<I, ?> kryo, I input2, Class<TextP> clazz2) {
            String predicate = input2.readString();
            String value2 = kryo.readObject(input2, String.class);
            try {
                return (TextP)TextP.class.getMethod(predicate, String.class).invoke(null, value2);
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }

    public static final class PSerializer
    implements SerializerShim<P> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, P p) {
            output.writeString(p instanceof ConnectiveP ? (p instanceof AndP ? "and" : "or") : p.getBiPredicate().toString());
            if (p instanceof ConnectiveP || p.getValue() instanceof Collection) {
                output.writeByte((byte)0);
                Collection<P<Object>> coll = p instanceof ConnectiveP ? ((ConnectiveP)p).getPredicates() : (Collection)p.getValue();
                output.writeInt(coll.size());
                coll.forEach(v -> kryo.writeClassAndObject(output, v));
            } else {
                output.writeByte((byte)1);
                kryo.writeClassAndObject(output, p.getValue());
            }
        }

        @Override
        public <I extends InputShim> P read(KryoShim<I, ?> kryo, I input2, Class<P> clazz2) {
            Object value2;
            boolean isCollection;
            String predicate = input2.readString();
            boolean bl = isCollection = input2.readByte() == 0;
            if (isCollection) {
                value2 = new ArrayList();
                int size2 = input2.readInt();
                for (int ix = 0; ix < size2; ++ix) {
                    ((List)value2).add(kryo.readClassAndObject(input2));
                }
            } else {
                value2 = kryo.readClassAndObject(input2);
            }
            try {
                if (predicate.equals("and") || predicate.equals("or")) {
                    return predicate.equals("and") ? new AndP((List)value2) : new OrP((List)value2);
                }
                if (value2 instanceof Collection) {
                    if (predicate.equals("between")) {
                        return P.between(((List)value2).get(0), ((List)value2).get(1));
                    }
                    if (predicate.equals("inside")) {
                        return P.inside(((List)value2).get(0), ((List)value2).get(1));
                    }
                    if (predicate.equals("outside")) {
                        return P.outside(((List)value2).get(0), ((List)value2).get(1));
                    }
                    if (predicate.equals("within")) {
                        return P.within((Collection)value2);
                    }
                    if (predicate.equals("without")) {
                        return P.without((Collection)value2);
                    }
                    return (P)P.class.getMethod(predicate, Collection.class).invoke(null, (Collection)value2);
                }
                return (P)P.class.getMethod(predicate, Object.class).invoke(null, value2);
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }

    public static final class BytecodeSerializer
    implements SerializerShim<Bytecode> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, Bytecode bytecode) {
            BytecodeSerializer.writeInstructions(kryo, output, bytecode.getSourceInstructions());
            BytecodeSerializer.writeInstructions(kryo, output, bytecode.getStepInstructions());
        }

        @Override
        public <I extends InputShim> Bytecode read(KryoShim<I, ?> kryo, I input2, Class<Bytecode> clazz2) {
            Bytecode bytecode = new Bytecode();
            int sourceInstructionCount = input2.readInt();
            for (int ix = 0; ix < sourceInstructionCount; ++ix) {
                String operator = input2.readString();
                Object[] args2 = operator.equals("withoutStrategies") ? (Object[])kryo.readObject(input2, Class[].class) : kryo.readObject(input2, Object[].class);
                bytecode.addSource(operator, args2);
            }
            int stepInstructionCount = input2.readInt();
            for (int ix = 0; ix < stepInstructionCount; ++ix) {
                String operator = input2.readString();
                Object[] args3 = kryo.readObject(input2, Object[].class);
                bytecode.addStep(operator, args3);
            }
            return bytecode;
        }

        private static <O extends OutputShim> void writeInstructions(KryoShim<?, O> kryo, O output, List<Bytecode.Instruction> instructions2) {
            output.writeInt(instructions2.size());
            for (Bytecode.Instruction inst : instructions2) {
                output.writeString(inst.getOperator());
                kryo.writeObject(output, inst.getArguments());
            }
        }
    }

    public static final class PathSerializer
    implements SerializerShim<Path> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, Path path) {
            kryo.writeClassAndObject(output, DetachedFactory.detach(path, false));
        }

        @Override
        public <I extends InputShim> Path read(KryoShim<I, ?> kryo, I input2, Class<Path> pathClass) {
            return (Path)kryo.readClassAndObject(input2);
        }
    }

    public static final class VertexPropertySerializer
    implements SerializerShim<VertexProperty> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, VertexProperty vertexProperty) {
            kryo.writeClassAndObject(output, vertexProperty.id());
            output.writeString(vertexProperty.label());
            kryo.writeClassAndObject(output, vertexProperty.value());
            kryo.writeClassAndObject(output, vertexProperty.element().id());
            output.writeString(vertexProperty.element().label());
            if (vertexProperty instanceof DetachedVertexProperty || vertexProperty.graph().features().vertex().supportsMetaProperties()) {
                GryoSerializersV3d0.writeElementProperties(kryo, output, vertexProperty);
            } else {
                output.writeBoolean(false);
            }
        }

        @Override
        public <I extends InputShim> VertexProperty read(KryoShim<I, ?> kryo, I input2, Class<VertexProperty> vertexPropertyClass) {
            DetachedVertexProperty.Builder vpBuilder = DetachedVertexProperty.build();
            vpBuilder.setId(kryo.readClassAndObject(input2));
            vpBuilder.setLabel(input2.readString());
            vpBuilder.setValue(kryo.readClassAndObject(input2));
            DetachedVertex.Builder host = DetachedVertex.build();
            host.setId(kryo.readClassAndObject(input2));
            host.setLabel(input2.readString());
            vpBuilder.setV(host.create());
            while (input2.readBoolean()) {
                vpBuilder.addProperty(new DetachedProperty<Object>(input2.readString(), kryo.readClassAndObject(input2)));
            }
            return vpBuilder.create();
        }
    }

    public static final class PropertySerializer
    implements SerializerShim<Property> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, Property property) {
            output.writeString(property.key());
            kryo.writeClassAndObject(output, property.value());
            kryo.writeClassAndObject(output, property.element().id());
            output.writeString(property.element().label());
        }

        @Override
        public <I extends InputShim> Property read(KryoShim<I, ?> kryo, I input2, Class<Property> propertyClass) {
            return new DetachedProperty<Object>(input2.readString(), kryo.readClassAndObject(input2), DetachedVertex.build().setId(kryo.readClassAndObject(input2)).setLabel(input2.readString()).create());
        }
    }

    public static final class VertexSerializer
    implements SerializerShim<Vertex> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, Vertex vertex) {
            kryo.writeClassAndObject(output, vertex.id());
            output.writeString(vertex.label());
            Iterator properties2 = vertex.properties(new String[0]);
            output.writeBoolean(properties2.hasNext());
            while (properties2.hasNext()) {
                VertexProperty vp = properties2.next();
                kryo.writeClassAndObject(output, vp.id());
                output.writeString(vp.label());
                kryo.writeClassAndObject(output, vp.value());
                if (vp instanceof DetachedVertexProperty || vertex.graph().features().vertex().supportsMetaProperties()) {
                    GryoSerializersV3d0.writeElementProperties(kryo, output, vp);
                } else {
                    output.writeBoolean(false);
                }
                output.writeBoolean(properties2.hasNext());
            }
        }

        @Override
        public <I extends InputShim> Vertex read(KryoShim<I, ?> kryo, I input2, Class<Vertex> vertexClass) {
            DetachedVertex.Builder builder = DetachedVertex.build();
            builder.setId(kryo.readClassAndObject(input2));
            builder.setLabel(input2.readString());
            while (input2.readBoolean()) {
                DetachedVertexProperty.Builder vpBuilder = DetachedVertexProperty.build();
                vpBuilder.setId(kryo.readClassAndObject(input2));
                vpBuilder.setLabel(input2.readString());
                vpBuilder.setValue(kryo.readClassAndObject(input2));
                while (input2.readBoolean()) {
                    vpBuilder.addProperty(new DetachedProperty<Object>(input2.readString(), kryo.readClassAndObject(input2)));
                }
                builder.addProperty(vpBuilder.create());
            }
            return builder.create();
        }
    }

    public static final class EdgeSerializer
    implements SerializerShim<Edge> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, Edge edge) {
            kryo.writeClassAndObject(output, edge.id());
            output.writeString(edge.label());
            kryo.writeClassAndObject(output, edge.inVertex().id());
            try {
                output.writeString(edge.inVertex().label());
            }
            catch (Exception ex) {
                output.writeString("vertex");
            }
            kryo.writeClassAndObject(output, edge.outVertex().id());
            try {
                output.writeString(edge.outVertex().label());
            }
            catch (Exception ex) {
                output.writeString("vertex");
            }
            GryoSerializersV3d0.writeElementProperties(kryo, output, edge);
        }

        @Override
        public <I extends InputShim> Edge read(KryoShim<I, ?> kryo, I input2, Class<Edge> edgeClass) {
            DetachedEdge.Builder builder = DetachedEdge.build();
            builder.setId(kryo.readClassAndObject(input2));
            builder.setLabel(input2.readString());
            DetachedVertex.Builder inV = DetachedVertex.build();
            inV.setId(kryo.readClassAndObject(input2));
            inV.setLabel(input2.readString());
            builder.setInV(inV.create());
            DetachedVertex.Builder outV = DetachedVertex.build();
            outV.setId(kryo.readClassAndObject(input2));
            outV.setLabel(input2.readString());
            builder.setOutV(outV.create());
            while (input2.readBoolean()) {
                builder.addProperty(new DetachedProperty<Object>(input2.readString(), kryo.readClassAndObject(input2)));
            }
            return builder.create();
        }
    }
}

