/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.gryo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.tinkerpop.gremlin.process.remote.traversal.DefaultRemoteTraverser;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.TextP;
import org.apache.tinkerpop.gremlin.process.traversal.util.AndP;
import org.apache.tinkerpop.gremlin.process.traversal.util.ConnectiveP;
import org.apache.tinkerpop.gremlin.process.traversal.util.OrP;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.InputShim;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.KryoShim;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.OutputShim;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.SerializerShim;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedFactory;
import org.apache.tinkerpop.gremlin.util.function.Lambda;

public final class GryoSerializersV1d0 {

    public static final class DefaultRemoteTraverserSerializer
    implements SerializerShim<DefaultRemoteTraverser> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, DefaultRemoteTraverser remoteTraverser) {
            kryo.writeClassAndObject(output, remoteTraverser.get());
            output.writeLong(remoteTraverser.bulk());
        }

        @Override
        public <I extends InputShim> DefaultRemoteTraverser read(KryoShim<I, ?> kryo, I input2, Class<DefaultRemoteTraverser> remoteTraverserClass) {
            Object o = kryo.readClassAndObject(input2);
            return new DefaultRemoteTraverser<Object>(o, input2.readLong());
        }
    }

    public static final class BindingSerializer
    implements SerializerShim<Bytecode.Binding> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, Bytecode.Binding binding) {
            output.writeString(binding.variable());
            kryo.writeClassAndObject(output, binding.value());
        }

        @Override
        public <I extends InputShim> Bytecode.Binding read(KryoShim<I, ?> kryo, I input2, Class<Bytecode.Binding> clazz2) {
            String var = input2.readString();
            Object val = kryo.readClassAndObject(input2);
            return new Bytecode.Binding<Object>(var, val);
        }
    }

    public static final class LambdaSerializer
    implements SerializerShim<Lambda> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, Lambda lambda) {
            output.writeString(lambda.getLambdaScript());
            output.writeString(lambda.getLambdaLanguage());
            output.writeInt(lambda.getLambdaArguments());
        }

        @Override
        public <I extends InputShim> Lambda read(KryoShim<I, ?> kryo, I input2, Class<Lambda> clazz2) {
            String script = input2.readString();
            String language2 = input2.readString();
            int arguments = input2.readInt();
            if (-1 == arguments || arguments > 2) {
                return new Lambda.UnknownArgLambda(script, language2, arguments);
            }
            if (0 == arguments) {
                return new Lambda.ZeroArgLambda(script, language2);
            }
            if (1 == arguments) {
                return new Lambda.OneArgLambda(script, language2);
            }
            return new Lambda.TwoArgLambda(script, language2);
        }
    }

    public static final class TextPSerializer
    implements SerializerShim<TextP> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, TextP p) {
            output.writeString(p.getBiPredicate().toString());
            kryo.writeObject(output, p.getValue());
        }

        @Override
        public <I extends InputShim> TextP read(KryoShim<I, ?> kryo, I input2, Class<TextP> clazz2) {
            String predicate = input2.readString();
            String value2 = kryo.readObject(input2, String.class);
            try {
                return (TextP)TextP.class.getMethod(predicate, String.class).invoke(null, value2);
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }

    public static final class PSerializer
    implements SerializerShim<P> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, P p) {
            output.writeString(p instanceof ConnectiveP ? (p instanceof AndP ? "and" : "or") : p.getBiPredicate().toString());
            if (p instanceof ConnectiveP || p.getValue() instanceof Collection) {
                output.writeByte((byte)0);
                Collection<P<Object>> coll = p instanceof ConnectiveP ? ((ConnectiveP)p).getPredicates() : (Collection)p.getValue();
                output.writeInt(coll.size());
                coll.forEach(v -> kryo.writeClassAndObject(output, v));
            } else {
                output.writeByte((byte)1);
                kryo.writeClassAndObject(output, p.getValue());
            }
        }

        @Override
        public <I extends InputShim> P read(KryoShim<I, ?> kryo, I input2, Class<P> clazz2) {
            Object value2;
            boolean isCollection;
            String predicate = input2.readString();
            boolean bl = isCollection = input2.readByte() == 0;
            if (isCollection) {
                value2 = new ArrayList();
                int size2 = input2.readInt();
                for (int ix = 0; ix < size2; ++ix) {
                    ((List)value2).add(kryo.readClassAndObject(input2));
                }
            } else {
                value2 = kryo.readClassAndObject(input2);
            }
            try {
                if (predicate.equals("and") || predicate.equals("or")) {
                    return predicate.equals("and") ? new AndP((List)value2) : new OrP((List)value2);
                }
                if (value2 instanceof Collection) {
                    if (predicate.equals("between")) {
                        return P.between(((List)value2).get(0), ((List)value2).get(1));
                    }
                    if (predicate.equals("inside")) {
                        return P.inside(((List)value2).get(0), ((List)value2).get(1));
                    }
                    if (predicate.equals("outside")) {
                        return P.outside(((List)value2).get(0), ((List)value2).get(1));
                    }
                    if (predicate.equals("within")) {
                        return P.within((Collection)value2);
                    }
                    if (predicate.equals("without")) {
                        return P.without((Collection)value2);
                    }
                    return (P)P.class.getMethod(predicate, Collection.class).invoke(null, (Collection)value2);
                }
                return (P)P.class.getMethod(predicate, Object.class).invoke(null, value2);
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }

    public static final class BytecodeSerializer
    implements SerializerShim<Bytecode> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, Bytecode bytecode) {
            BytecodeSerializer.writeInstructions(kryo, output, bytecode.getSourceInstructions());
            BytecodeSerializer.writeInstructions(kryo, output, bytecode.getStepInstructions());
        }

        @Override
        public <I extends InputShim> Bytecode read(KryoShim<I, ?> kryo, I input2, Class<Bytecode> clazz2) {
            Bytecode bytecode = new Bytecode();
            int sourceInstructionCount = input2.readInt();
            for (int ix = 0; ix < sourceInstructionCount; ++ix) {
                String operator = input2.readString();
                Object[] args2 = operator.equals("withoutStrategies") ? (Object[])kryo.readObject(input2, Class[].class) : kryo.readObject(input2, Object[].class);
                bytecode.addSource(operator, args2);
            }
            int stepInstructionCount = input2.readInt();
            for (int ix = 0; ix < stepInstructionCount; ++ix) {
                String operator = input2.readString();
                Object[] args3 = kryo.readObject(input2, Object[].class);
                bytecode.addStep(operator, args3);
            }
            return bytecode;
        }

        private static <O extends OutputShim> void writeInstructions(KryoShim<?, O> kryo, O output, List<Bytecode.Instruction> instructions2) {
            output.writeInt(instructions2.size());
            for (Bytecode.Instruction inst : instructions2) {
                output.writeString(inst.getOperator());
                kryo.writeObject(output, inst.getArguments());
            }
        }
    }

    public static final class PathSerializer
    implements SerializerShim<Path> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, Path path) {
            kryo.writeClassAndObject(output, DetachedFactory.detach(path, false));
        }

        @Override
        public <I extends InputShim> Path read(KryoShim<I, ?> kryo, I input2, Class<Path> pathClass) {
            return (Path)kryo.readClassAndObject(input2);
        }
    }

    public static final class VertexPropertySerializer
    implements SerializerShim<VertexProperty> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, VertexProperty vertexProperty) {
            kryo.writeClassAndObject(output, DetachedFactory.detach(vertexProperty, true));
        }

        @Override
        public <I extends InputShim> VertexProperty read(KryoShim<I, ?> kryo, I input2, Class<VertexProperty> vertexPropertyClass) {
            return (VertexProperty)kryo.readClassAndObject(input2);
        }
    }

    public static final class PropertySerializer
    implements SerializerShim<Property> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, Property property) {
            kryo.writeClassAndObject(output, property instanceof VertexProperty ? DetachedFactory.detach((VertexProperty)property, true) : DetachedFactory.detach(property));
        }

        @Override
        public <I extends InputShim> Property read(KryoShim<I, ?> kryo, I input2, Class<Property> propertyClass) {
            return (Property)kryo.readClassAndObject(input2);
        }
    }

    public static final class VertexSerializer
    implements SerializerShim<Vertex> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, Vertex vertex) {
            kryo.writeClassAndObject(output, DetachedFactory.detach(vertex, true));
        }

        @Override
        public <I extends InputShim> Vertex read(KryoShim<I, ?> kryo, I input2, Class<Vertex> vertexClass) {
            return (Vertex)kryo.readClassAndObject(input2);
        }
    }

    public static final class EdgeSerializer
    implements SerializerShim<Edge> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, Edge edge) {
            kryo.writeClassAndObject(output, DetachedFactory.detach(edge, true));
        }

        @Override
        public <I extends InputShim> Edge read(KryoShim<I, ?> kryo, I input2, Class<Edge> edgeClass) {
            Object o = kryo.readClassAndObject(input2);
            return (Edge)o;
        }
    }
}

