/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.graphson;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationConverter;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.tinkerpop.gremlin.process.remote.traversal.DefaultRemoteTraverser;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.TextP;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.TraversalStrategyProxy;
import org.apache.tinkerpop.gremlin.process.traversal.util.AndP;
import org.apache.tinkerpop.gremlin.process.traversal.util.ConnectiveP;
import org.apache.tinkerpop.gremlin.process.traversal.util.OrP;
import org.apache.tinkerpop.gremlin.structure.io.graphson.AbstractObjectDeserializer;
import org.apache.tinkerpop.gremlin.util.function.Lambda;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.core.JsonParser;
import org.apache.tinkerpop.shaded.jackson.core.JsonProcessingException;
import org.apache.tinkerpop.shaded.jackson.core.JsonToken;
import org.apache.tinkerpop.shaded.jackson.databind.DeserializationContext;
import org.apache.tinkerpop.shaded.jackson.databind.SerializerProvider;
import org.apache.tinkerpop.shaded.jackson.databind.deser.std.StdDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdScalarSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdSerializer;

final class TraversalSerializersV2d0 {
    private TraversalSerializersV2d0() {
    }

    static final class TraversalStrategyProxyJacksonDeserializer<T extends TraversalStrategy>
    extends AbstractObjectDeserializer<TraversalStrategyProxy> {
        private final Class<T> clazz;

        public TraversalStrategyProxyJacksonDeserializer(Class<T> clazz2) {
            super(TraversalStrategyProxy.class);
            this.clazz = clazz2;
        }

        @Override
        public TraversalStrategyProxy<T> createObject(Map<String, Object> data2) {
            return new TraversalStrategyProxy<T>(this.clazz, new MapConfiguration(data2));
        }
    }

    static class TraverserJacksonDeserializer
    extends StdDeserializer<Traverser> {
        public TraverserJacksonDeserializer() {
            super(Traverser.class);
        }

        @Override
        public Traverser deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            long bulk = 1L;
            Object v = null;
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                if (jsonParser.getCurrentName().equals("bulk")) {
                    jsonParser.nextToken();
                    bulk = deserializationContext.readValue(jsonParser, Long.class);
                    continue;
                }
                if (!jsonParser.getCurrentName().equals("value")) continue;
                jsonParser.nextToken();
                v = deserializationContext.readValue(jsonParser, Object.class);
            }
            return new DefaultRemoteTraverser<Object>(v, bulk);
        }

        @Override
        public boolean isCachable() {
            return true;
        }
    }

    static final class BindingJacksonDeserializer
    extends StdDeserializer<Bytecode.Binding> {
        public BindingJacksonDeserializer() {
            super(Bytecode.Binding.class);
        }

        @Override
        public Bytecode.Binding deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            String k = null;
            Object v = null;
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                if (jsonParser.getCurrentName().equals("key")) {
                    jsonParser.nextToken();
                    k = jsonParser.getText();
                    continue;
                }
                if (!jsonParser.getCurrentName().equals("value")) continue;
                jsonParser.nextToken();
                v = deserializationContext.readValue(jsonParser, Object.class);
            }
            return new Bytecode.Binding<Object>(k, v);
        }

        @Override
        public boolean isCachable() {
            return true;
        }
    }

    static final class LambdaJacksonDeserializer
    extends StdDeserializer<Lambda> {
        public LambdaJacksonDeserializer() {
            super(Lambda.class);
        }

        @Override
        public Lambda deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            String script = null;
            String language2 = null;
            int arguments = -1;
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                if (jsonParser.getCurrentName().equals("script")) {
                    jsonParser.nextToken();
                    script = jsonParser.getText();
                    continue;
                }
                if (jsonParser.getCurrentName().equals("language")) {
                    jsonParser.nextToken();
                    language2 = jsonParser.getText();
                    continue;
                }
                if (!jsonParser.getCurrentName().equals("arguments")) continue;
                jsonParser.nextToken();
                arguments = jsonParser.getIntValue();
            }
            if (-1 == arguments || arguments > 2) {
                return new Lambda.UnknownArgLambda(script, language2, arguments);
            }
            if (0 == arguments) {
                return new Lambda.ZeroArgLambda(script, language2);
            }
            if (1 == arguments) {
                return new Lambda.OneArgLambda(script, language2);
            }
            return new Lambda.TwoArgLambda(script, language2);
        }

        @Override
        public boolean isCachable() {
            return true;
        }
    }

    static final class TextPJacksonDeserializer
    extends StdDeserializer<TextP> {
        public TextPJacksonDeserializer() {
            super(TextP.class);
        }

        @Override
        public TextP deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            String predicate = null;
            String value2 = null;
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                if (jsonParser.getCurrentName().equals("predicate")) {
                    jsonParser.nextToken();
                    predicate = jsonParser.getText();
                    continue;
                }
                if (!jsonParser.getCurrentName().equals("value")) continue;
                jsonParser.nextToken();
                value2 = deserializationContext.readValue(jsonParser, String.class);
            }
            try {
                return (TextP)TextP.class.getMethod(predicate, String.class).invoke(null, value2);
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }

        @Override
        public boolean isCachable() {
            return true;
        }
    }

    static final class PJacksonDeserializer
    extends StdDeserializer<P> {
        public PJacksonDeserializer() {
            super(P.class);
        }

        @Override
        public P deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            String predicate = null;
            Object value2 = null;
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                if (jsonParser.getCurrentName().equals("predicate")) {
                    jsonParser.nextToken();
                    predicate = jsonParser.getText();
                    continue;
                }
                if (!jsonParser.getCurrentName().equals("value")) continue;
                jsonParser.nextToken();
                value2 = deserializationContext.readValue(jsonParser, Object.class);
            }
            if (predicate.equals("and") || predicate.equals("or")) {
                return predicate.equals("and") ? new AndP((List)value2) : new OrP((List)value2);
            }
            if (predicate.equals("not") && value2 instanceof P) {
                return P.not((P)value2);
            }
            try {
                if (value2 instanceof Collection) {
                    if (predicate.equals("between")) {
                        return P.between(((List)value2).get(0), ((List)value2).get(1));
                    }
                    if (predicate.equals("inside")) {
                        return P.between(((List)value2).get(0), ((List)value2).get(1));
                    }
                    if (predicate.equals("outside")) {
                        return P.outside(((List)value2).get(0), ((List)value2).get(1));
                    }
                    if (predicate.equals("within")) {
                        return P.within((Collection)value2);
                    }
                    if (predicate.equals("without")) {
                        return P.without((Collection)value2);
                    }
                    return (P)P.class.getMethod(predicate, Collection.class).invoke(null, (Collection)value2);
                }
                try {
                    return (P)P.class.getMethod(predicate, Object.class).invoke(null, value2);
                }
                catch (NoSuchMethodException e) {
                    return (P)P.class.getMethod(predicate, Object[].class).invoke(null, new Object[]{new Object[]{value2}});
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }

        @Override
        public boolean isCachable() {
            return true;
        }
    }

    static final class EnumJacksonDeserializer<A extends Enum>
    extends StdDeserializer<A> {
        public EnumJacksonDeserializer(Class<A> enumClass) {
            super(enumClass);
        }

        @Override
        public A deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            Class enumClass = this._valueClass;
            String enumName = jsonParser.getText();
            for (Enum a : (Enum[])enumClass.getEnumConstants()) {
                if (!a.name().equals(enumName)) continue;
                return (A)a;
            }
            throw new IOException("Unknown enum type: " + enumClass);
        }

        @Override
        public boolean isCachable() {
            return true;
        }
    }

    static final class BytecodeJacksonDeserializer
    extends StdDeserializer<Bytecode> {
        public BytecodeJacksonDeserializer() {
            super(Bytecode.class);
        }

        @Override
        public Bytecode deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            Bytecode bytecode = new Bytecode();
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                String current = jsonParser.getCurrentName();
                if (!current.equals("source") && !current.equals("step")) continue;
                jsonParser.nextToken();
                while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    jsonParser.nextToken();
                    String stepName = jsonParser.getText();
                    ArrayList<Object> arguments = new ArrayList<Object>();
                    while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                        arguments.add(deserializationContext.readValue(jsonParser, Object.class));
                    }
                    if (current.equals("source")) {
                        bytecode.addSource(stepName, arguments.toArray());
                        continue;
                    }
                    bytecode.addStep(stepName, arguments.toArray());
                }
            }
            return bytecode;
        }

        @Override
        public boolean isCachable() {
            return true;
        }
    }

    static final class TraversalStrategyJacksonSerializer
    extends StdScalarSerializer<TraversalStrategy> {
        public TraversalStrategyJacksonSerializer() {
            super(TraversalStrategy.class);
        }

        @Override
        public void serialize(TraversalStrategy traversalStrategy, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            for (Map.Entry<Object, Object> entry2 : ConfigurationConverter.getMap(traversalStrategy.getConfiguration()).entrySet()) {
                jsonGenerator.writeObjectField((String)entry2.getKey(), entry2.getValue());
            }
            jsonGenerator.writeEndObject();
        }
    }

    static final class TraverserJacksonSerializer
    extends StdScalarSerializer<Traverser> {
        public TraverserJacksonSerializer() {
            super(Traverser.class);
        }

        @Override
        public void serialize(Traverser traverserInstance, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeObjectField("bulk", traverserInstance.bulk());
            jsonGenerator.writeObjectField("value", traverserInstance.get());
            jsonGenerator.writeEndObject();
        }
    }

    static final class BindingJacksonSerializer
    extends StdScalarSerializer<Bytecode.Binding> {
        public BindingJacksonSerializer() {
            super(Bytecode.Binding.class);
        }

        @Override
        public void serialize(Bytecode.Binding binding, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("key", binding.variable());
            jsonGenerator.writeObjectField("value", binding.value());
            jsonGenerator.writeEndObject();
        }
    }

    static final class LambdaJacksonSerializer
    extends StdScalarSerializer<Lambda> {
        public LambdaJacksonSerializer() {
            super(Lambda.class);
        }

        @Override
        public void serialize(Lambda lambda, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("script", lambda.getLambdaScript());
            jsonGenerator.writeStringField("language", lambda.getLambdaLanguage());
            jsonGenerator.writeNumberField("arguments", lambda.getLambdaArguments());
            jsonGenerator.writeEndObject();
        }
    }

    static final class PJacksonSerializer
    extends StdScalarSerializer<P> {
        public PJacksonSerializer() {
            super(P.class);
        }

        @Override
        public void serialize(P p, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("predicate", p instanceof ConnectiveP ? (p instanceof AndP ? "and" : "or") : p.getBiPredicate().toString());
            if (p instanceof ConnectiveP) {
                jsonGenerator.writeArrayFieldStart("value");
                for (P predicate : ((ConnectiveP)p).getPredicates()) {
                    jsonGenerator.writeObject(predicate);
                }
                jsonGenerator.writeEndArray();
            } else if (p.getValue() instanceof Collection) {
                jsonGenerator.writeArrayFieldStart("value");
                for (Object object : (Collection)p.getValue()) {
                    jsonGenerator.writeObject(object);
                }
                jsonGenerator.writeEndArray();
            } else {
                jsonGenerator.writeObjectField("value", p.getValue());
            }
            jsonGenerator.writeEndObject();
        }
    }

    static class EnumJacksonSerializer
    extends StdScalarSerializer<Enum> {
        public EnumJacksonSerializer() {
            super(Enum.class);
        }

        @Override
        public void serialize(Enum enumInstance, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeString(enumInstance.name());
        }
    }

    static final class BytecodeJacksonSerializer
    extends StdScalarSerializer<Bytecode> {
        public BytecodeJacksonSerializer() {
            super(Bytecode.class);
        }

        @Override
        public void serialize(Bytecode bytecode, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            if (bytecode.getSourceInstructions().iterator().hasNext()) {
                jsonGenerator.writeArrayFieldStart("source");
                for (Bytecode.Instruction instruction : bytecode.getSourceInstructions()) {
                    jsonGenerator.writeStartArray();
                    jsonGenerator.writeString(instruction.getOperator());
                    for (Object argument2 : instruction.getArguments()) {
                        jsonGenerator.writeObject(argument2);
                    }
                    jsonGenerator.writeEndArray();
                }
                jsonGenerator.writeEndArray();
            }
            if (bytecode.getStepInstructions().iterator().hasNext()) {
                jsonGenerator.writeArrayFieldStart("step");
                for (Bytecode.Instruction instruction : bytecode.getStepInstructions()) {
                    jsonGenerator.writeStartArray();
                    jsonGenerator.writeString(instruction.getOperator());
                    for (Object argument2 : instruction.getArguments()) {
                        jsonGenerator.writeObject(argument2);
                    }
                    jsonGenerator.writeEndArray();
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
    }

    static final class TraversalJacksonSerializer
    extends StdSerializer<Traversal> {
        public TraversalJacksonSerializer() {
            super(Traversal.class);
        }

        @Override
        public void serialize(Traversal traversal, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeObject(traversal.asAdmin().getBytecode());
        }

        @Override
        public void serializeWithType(Traversal traversal, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
            this.serialize(traversal, jsonGenerator, serializerProvider);
        }
    }
}

