/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.graphson;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.io.GraphReader;
import org.apache.tinkerpop.gremlin.structure.io.Io;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONMapper;
import org.apache.tinkerpop.gremlin.structure.io.graphson.TypeInfo;
import org.apache.tinkerpop.gremlin.structure.util.Attachable;
import org.apache.tinkerpop.shaded.jackson.core.JsonFactory;
import org.apache.tinkerpop.shaded.jackson.core.JsonParser;
import org.apache.tinkerpop.shaded.jackson.core.JsonToken;
import org.apache.tinkerpop.shaded.jackson.databind.JsonNode;
import org.apache.tinkerpop.shaded.jackson.databind.ObjectMapper;
import org.apache.tinkerpop.shaded.jackson.databind.module.SimpleModule;

public final class LegacyGraphSONReader
implements GraphReader {
    private final ObjectMapper mapper;
    private final long batchSize;

    private LegacyGraphSONReader(ObjectMapper mapper2, long batchSize) {
        this.mapper = mapper2;
        this.batchSize = batchSize;
    }

    @Override
    public void readGraph(InputStream inputStream, Graph graphToWriteTo) throws IOException {
        HashMap<Object, Vertex> cache2 = new HashMap<Object, Vertex>();
        AtomicLong counter = new AtomicLong(0L);
        boolean supportsTx = graphToWriteTo.features().graph().supportsTransactions();
        Graph.Features.EdgeFeatures edgeFeatures = graphToWriteTo.features().edge();
        Graph.Features.VertexFeatures vertexFeatures = graphToWriteTo.features().vertex();
        JsonFactory factory = this.mapper.getFactory();
        LegacyGraphSONUtility graphson = new LegacyGraphSONUtility(graphToWriteTo, vertexFeatures, edgeFeatures, cache2);
        try (JsonParser parser2 = factory.createParser(inputStream);){
            if (parser2.nextToken() != JsonToken.START_OBJECT) {
                throw new IOException("Expected data to start with an Object");
            }
            block21: while (parser2.nextToken() != JsonToken.END_OBJECT) {
                String fieldName;
                switch (fieldName = parser2.getCurrentName() == null ? "" : parser2.getCurrentName()) {
                    case "mode": {
                        parser2.nextToken();
                        String mode = parser2.getText();
                        if (mode.equals("EXTENDED")) continue block21;
                        throw new IllegalStateException("The legacy GraphSON must be generated with GraphSONMode.EXTENDED");
                    }
                    case "vertices": {
                        JsonNode node;
                        parser2.nextToken();
                        while (parser2.nextToken() != JsonToken.END_ARRAY) {
                            node = (JsonNode)parser2.readValueAsTree();
                            graphson.vertexFromJson(node);
                            if (!supportsTx || counter.incrementAndGet() % this.batchSize != 0L) continue;
                            graphToWriteTo.tx().commit();
                        }
                        continue block21;
                    }
                    case "edges": {
                        JsonNode node;
                        parser2.nextToken();
                        while (parser2.nextToken() != JsonToken.END_ARRAY) {
                            node = (JsonNode)parser2.readValueAsTree();
                            Vertex inV = (Vertex)cache2.get(LegacyGraphSONUtility.getTypedValueFromJsonNode(node.get("_inV")));
                            Vertex outV = (Vertex)cache2.get(LegacyGraphSONUtility.getTypedValueFromJsonNode(node.get("_outV")));
                            graphson.edgeFromJson(node, outV, inV);
                            if (!supportsTx || counter.incrementAndGet() % this.batchSize != 0L) continue;
                            graphToWriteTo.tx().commit();
                        }
                        continue block21;
                    }
                }
                throw new IllegalStateException(String.format("Unexpected token in GraphSON - %s", fieldName));
            }
            if (supportsTx) {
                graphToWriteTo.tx().commit();
            }
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public Iterator<Vertex> readVertices(InputStream inputStream, Function<Attachable<Vertex>, Vertex> vertexAttachMethod, Function<Attachable<Edge>, Edge> edgeAttachMethod, Direction attachEdgesOfThisDirection) throws IOException {
        throw Io.Exceptions.readerFormatIsForFullGraphSerializationOnly(this.getClass());
    }

    @Override
    public Edge readEdge(InputStream inputStream, Function<Attachable<Edge>, Edge> edgeAttachMethod) throws IOException {
        throw Io.Exceptions.readerFormatIsForFullGraphSerializationOnly(this.getClass());
    }

    @Override
    public Vertex readVertex(InputStream inputStream, Function<Attachable<Vertex>, Vertex> vertexAttachMethod) throws IOException {
        throw Io.Exceptions.readerFormatIsForFullGraphSerializationOnly(this.getClass());
    }

    @Override
    public Vertex readVertex(InputStream inputStream, Function<Attachable<Vertex>, Vertex> vertexAttachMethod, Function<Attachable<Edge>, Edge> edgeAttachMethod, Direction attachEdgesOfThisDirection) throws IOException {
        throw Io.Exceptions.readerFormatIsForFullGraphSerializationOnly(this.getClass());
    }

    @Override
    public VertexProperty readVertexProperty(InputStream inputStream, Function<Attachable<VertexProperty>, VertexProperty> vertexPropertyAttachMethod) throws IOException {
        throw Io.Exceptions.readerFormatIsForFullGraphSerializationOnly(this.getClass());
    }

    @Override
    public Property readProperty(InputStream inputStream, Function<Attachable<Property>, Property> propertyAttachMethod) throws IOException {
        throw Io.Exceptions.readerFormatIsForFullGraphSerializationOnly(this.getClass());
    }

    @Override
    public <C> C readObject(InputStream inputStream, Class<? extends C> clazz2) throws IOException {
        throw Io.Exceptions.readerFormatIsForFullGraphSerializationOnly(this.getClass());
    }

    public static Builder build() {
        return new Builder();
    }

    public static final class GraphSONTokensTP2 {
        public static final String _ID = "_id";
        public static final String _LABEL = "_label";
        public static final String _TYPE = "_type";
        public static final String _OUT_V = "_outV";
        public static final String _IN_V = "_inV";
        public static final String VALUE = "value";
        public static final String TYPE = "type";
        public static final String TYPE_LIST = "list";
        public static final String TYPE_STRING = "string";
        public static final String TYPE_DOUBLE = "double";
        public static final String TYPE_INTEGER = "integer";
        public static final String TYPE_FLOAT = "float";
        public static final String TYPE_MAP = "map";
        public static final String TYPE_BOOLEAN = "boolean";
        public static final String TYPE_LONG = "long";
        public static final String TYPE_SHORT = "short";
        public static final String TYPE_BYTE = "byte";
        public static final String TYPE_UNKNOWN = "unknown";
        public static final String VERTICES = "vertices";
        public static final String EDGES = "edges";
        public static final String MODE = "mode";

        private GraphSONTokensTP2() {
        }
    }

    static class LegacyGraphSONUtility {
        private static final String EMPTY_STRING = "";
        private final Graph g;
        private final Graph.Features.VertexFeatures vertexFeatures;
        private final Graph.Features.EdgeFeatures edgeFeatures;
        private final Map<Object, Vertex> cache;

        public LegacyGraphSONUtility(Graph g, Graph.Features.VertexFeatures vertexFeatures, Graph.Features.EdgeFeatures edgeFeatures, Map<Object, Vertex> cache2) {
            this.g = g;
            this.vertexFeatures = vertexFeatures;
            this.edgeFeatures = edgeFeatures;
            this.cache = cache2;
        }

        public Vertex vertexFromJson(JsonNode json) throws IOException {
            Map<String, Object> props = LegacyGraphSONUtility.readProperties(json);
            Object vertexId = LegacyGraphSONUtility.getTypedValueFromJsonNode(json.get("_id"));
            Vertex v = this.vertexFeatures.willAllowId(vertexId) ? this.g.addVertex(T.id, vertexId) : this.g.addVertex(new Object[0]);
            this.cache.put(vertexId, v);
            for (Map.Entry<String, Object> entry2 : props.entrySet()) {
                v.property(this.g.features().vertex().getCardinality(entry2.getKey()), entry2.getKey(), entry2.getValue(), new Object[0]);
            }
            return v;
        }

        public Edge edgeFromJson(JsonNode json, Vertex out, Vertex in) throws IOException {
            Map<String, Object> props = LegacyGraphSONUtility.readProperties(json);
            Object edgeId = LegacyGraphSONUtility.getTypedValueFromJsonNode(json.get("_id"));
            JsonNode nodeLabel = json.get("_label");
            String label = nodeLabel == null ? EMPTY_STRING : nodeLabel.textValue();
            Edge e = this.edgeFeatures.willAllowId(edgeId) ? out.addEdge(label, in, T.id, edgeId) : out.addEdge(label, in, new Object[0]);
            for (Map.Entry<String, Object> entry2 : props.entrySet()) {
                e.property(entry2.getKey(), entry2.getValue());
            }
            return e;
        }

        static Map<String, Object> readProperties(JsonNode node) {
            HashMap<String, Object> map2 = new HashMap<String, Object>();
            Iterator<Map.Entry<String, JsonNode>> iterator2 = node.fields();
            while (iterator2.hasNext()) {
                Object o;
                Map.Entry<String, JsonNode> entry2 = iterator2.next();
                if (LegacyGraphSONUtility.isReservedKey(entry2.getKey()) || (o = LegacyGraphSONUtility.readProperty(entry2.getValue())) == null) continue;
                map2.put(entry2.getKey(), o);
            }
            return map2;
        }

        private static boolean isReservedKey(String key) {
            return key.equals("_id") || key.equals("_type") || key.equals("_label") || key.equals("_outV") || key.equals("_inV");
        }

        private static Object readProperty(JsonNode node) {
            Object propertyValue = node.get("type").textValue().equals("unknown") ? null : (node.get("type").textValue().equals("boolean") ? Boolean.valueOf(node.get("value").booleanValue()) : (node.get("type").textValue().equals("float") ? Float.valueOf(Float.parseFloat(node.get("value").asText())) : (node.get("type").textValue().equals("byte") ? Byte.valueOf(Byte.parseByte(node.get("value").asText())) : (node.get("type").textValue().equals("short") ? Short.valueOf(Short.parseShort(node.get("value").asText())) : (node.get("type").textValue().equals("double") ? Double.valueOf(node.get("value").doubleValue()) : (node.get("type").textValue().equals("integer") ? Integer.valueOf(node.get("value").intValue()) : (node.get("type").textValue().equals("long") ? Long.valueOf(node.get("value").longValue()) : (node.get("type").textValue().equals("string") ? node.get("value").textValue() : (node.get("type").textValue().equals("list") ? LegacyGraphSONUtility.readProperties(node.get("value").elements()) : (node.get("type").textValue().equals("map") ? LegacyGraphSONUtility.readProperties(node.get("value")) : node.textValue()))))))))));
            return propertyValue;
        }

        private static List readProperties(Iterator<JsonNode> listOfNodes) {
            ArrayList<Object> array2 = new ArrayList<Object>();
            while (listOfNodes.hasNext()) {
                array2.add(LegacyGraphSONUtility.readProperty(listOfNodes.next()));
            }
            return array2;
        }

        static Object getTypedValueFromJsonNode(JsonNode node) {
            Object theValue = null;
            if (node != null && !node.isNull()) {
                theValue = node.isBoolean() ? Boolean.valueOf(node.booleanValue()) : (node.isDouble() ? Double.valueOf(node.doubleValue()) : (node.isFloatingPointNumber() ? Float.valueOf(node.floatValue()) : (node.isInt() ? Integer.valueOf(node.intValue()) : (node.isLong() ? Long.valueOf(node.longValue()) : (node.isTextual() ? node.textValue() : (node.isArray() ? node : (node.isObject() ? node : node.textValue())))))));
            }
            return theValue;
        }
    }

    public static final class Builder {
        private boolean loadCustomModules = false;
        private List<SimpleModule> customModules = new ArrayList<SimpleModule>();
        private long batchSize = 10000L;
        private boolean embedTypes = false;

        private Builder() {
        }

        public Builder addCustomModule(SimpleModule custom) {
            this.customModules.add(custom);
            return this;
        }

        public Builder loadCustomModules(boolean loadCustomModules) {
            this.loadCustomModules = loadCustomModules;
            return this;
        }

        public Builder batchSize(long batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public LegacyGraphSONReader create() {
            GraphSONMapper.Builder builder = GraphSONMapper.build();
            this.customModules.forEach(builder::addCustomModule);
            GraphSONMapper mapper2 = builder.typeInfo(this.embedTypes ? TypeInfo.PARTIAL_TYPES : TypeInfo.NO_TYPES).loadCustomModules(this.loadCustomModules).create();
            return new LegacyGraphSONReader(mapper2.createMapper(), this.batchSize);
        }
    }
}

