/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.graphson;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.core.JsonParser;
import org.apache.tinkerpop.shaded.jackson.core.JsonProcessingException;
import org.apache.tinkerpop.shaded.jackson.core.JsonToken;
import org.apache.tinkerpop.shaded.jackson.databind.DeserializationContext;
import org.apache.tinkerpop.shaded.jackson.databind.SerializerProvider;
import org.apache.tinkerpop.shaded.jackson.databind.deser.std.StdDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdSerializer;

final class JavaUtilSerializersV3d0 {
    private JavaUtilSerializersV3d0() {
    }

    static class ListJacksonDeserializer
    extends StdDeserializer<List> {
        protected ListJacksonDeserializer() {
            super(List.class);
        }

        @Override
        public List deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            LinkedList<Object> s2 = new LinkedList<Object>();
            while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                s2.add(deserializationContext.readValue(jsonParser, Object.class));
            }
            return s2;
        }
    }

    static class SetJacksonDeserializer
    extends StdDeserializer<Set> {
        protected SetJacksonDeserializer() {
            super(Set.class);
        }

        @Override
        public Set deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            LinkedHashSet<Object> s2 = new LinkedHashSet<Object>();
            while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                s2.add(deserializationContext.readValue(jsonParser, Object.class));
            }
            return s2;
        }
    }

    static class MapJacksonDeserializer
    extends StdDeserializer<Map> {
        protected MapJacksonDeserializer() {
            super(Map.class);
        }

        @Override
        public Map deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            LinkedHashMap<Object, Object> m = new LinkedHashMap<Object, Object>();
            while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                Object key = deserializationContext.readValue(jsonParser, Object.class);
                jsonParser.nextToken();
                Object val = deserializationContext.readValue(jsonParser, Object.class);
                m.put(key, val);
            }
            return m;
        }
    }

    static final class ListJacksonSerializer
    extends StdSerializer<List> {
        public ListJacksonSerializer() {
            super(List.class);
        }

        @Override
        public void serialize(List list2, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            for (Object o : list2) {
                jsonGenerator.writeObject(o);
            }
        }

        @Override
        public void serializeWithType(List list2, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
            typeSerializer.writeTypePrefixForArray(list2, jsonGenerator);
            this.serialize(list2, jsonGenerator, serializerProvider);
            typeSerializer.writeTypeSuffixForArray(list2, jsonGenerator);
        }
    }

    static final class SetJacksonSerializer
    extends StdSerializer<Set> {
        public SetJacksonSerializer() {
            super(Set.class);
        }

        @Override
        public void serialize(Set set2, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            for (Object o : set2) {
                jsonGenerator.writeObject(o);
            }
        }

        @Override
        public void serializeWithType(Set set2, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
            typeSerializer.writeTypePrefixForArray(set2, jsonGenerator);
            this.serialize(set2, jsonGenerator, serializerProvider);
            typeSerializer.writeTypeSuffixForArray(set2, jsonGenerator);
        }
    }

    static final class MapEntryJacksonSerializer
    extends StdSerializer<Map.Entry> {
        public MapEntryJacksonSerializer() {
            super(Map.Entry.class);
        }

        @Override
        public void serialize(Map.Entry entry2, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            HashMap m = new HashMap();
            if (entry2 != null) {
                m.put(entry2.getKey(), entry2.getValue());
            }
            jsonGenerator.writeObject(m);
        }

        @Override
        public void serializeWithType(Map.Entry entry2, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
            this.serialize(entry2, jsonGenerator, serializerProvider);
        }
    }

    static final class MapJacksonSerializer
    extends StdSerializer<Map> {
        public MapJacksonSerializer() {
            super(Map.class);
        }

        @Override
        public void serialize(Map map2, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            for (Map.Entry entry2 : map2.entrySet()) {
                jsonGenerator.writeObject(entry2.getKey());
                jsonGenerator.writeObject(entry2.getValue());
            }
        }

        @Override
        public void serializeWithType(Map map2, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
            typeSerializer.writeTypePrefixForObject(map2, jsonGenerator);
            this.serialize(map2, jsonGenerator, serializerProvider);
            typeSerializer.writeTypeSuffixForObject(map2, jsonGenerator);
        }
    }
}

