/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.graphson;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Tree;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.shaded.jackson.annotation.JsonTypeInfo;
import org.apache.tinkerpop.shaded.jackson.core.type.TypeReference;
import org.apache.tinkerpop.shaded.jackson.databind.DatabindContext;
import org.apache.tinkerpop.shaded.jackson.databind.JavaType;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeIdResolver;
import org.apache.tinkerpop.shaded.jackson.databind.type.TypeFactory;

public class GraphSONTypeIdResolver
implements TypeIdResolver {
    private final Map<String, JavaType> idToType = new HashMap<String, JavaType>();
    private final Map<Class, String> typeToId = new HashMap<Class, String>();

    public GraphSONTypeIdResolver addCustomType(String name2, Class clasz) {
        if (Tree.class.isAssignableFrom(clasz)) {
            this.idToType.put(name2, TypeFactory.defaultInstance().constructType(new TypeReference<Tree<? extends Element>>(){}));
        } else {
            this.idToType.put(name2, TypeFactory.defaultInstance().constructType(clasz));
        }
        this.typeToId.put(clasz, name2);
        return this;
    }

    public final Map<String, JavaType> getIdToType() {
        return this.idToType;
    }

    public final Map<Class, String> getTypeToId() {
        return this.typeToId;
    }

    @Override
    public void init(JavaType javaType2) {
    }

    @Override
    public String idFromValue(Object o) {
        return this.idFromValueAndType(o, o.getClass());
    }

    @Override
    public String idFromValueAndType(Object o, Class<?> aClass) {
        if (!this.typeToId.containsKey(aClass)) {
            throw new IllegalArgumentException(String.format("Could not find a type identifier for the class : %s. Make sure the value to serialize has a type identifier registered for its class.", aClass));
        }
        return this.typeToId.get(aClass);
    }

    @Override
    public String idFromBaseType() {
        return null;
    }

    @Override
    public JavaType typeFromId(DatabindContext databindContext, String s2) {
        return this.idToType.containsKey(s2) ? this.idToType.get(s2) : databindContext.constructType((Type)((Object)String.class));
    }

    @Override
    public String getDescForKnownTypeIds() {
        return "GraphSON advanced typing system";
    }

    @Override
    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CUSTOM;
    }
}

