/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.graphson;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Tree;
import org.apache.tinkerpop.gremlin.process.traversal.util.Metrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalExplanation;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalMetrics;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONUtil;
import org.apache.tinkerpop.gremlin.structure.util.Comparators;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertexProperty;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerationException;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.core.JsonProcessingException;
import org.apache.tinkerpop.shaded.jackson.databind.SerializerProvider;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdKeySerializer;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdSerializer;
import org.javatuples.Pair;

final class GraphSONSerializersV1d0 {
    private GraphSONSerializersV1d0() {
    }

    private static void serializerVertexProperty(VertexProperty property, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer, boolean normalize2, boolean includeLabel) throws IOException {
        jsonGenerator.writeStartObject();
        if (typeSerializer != null) {
            jsonGenerator.writeStringField("@class", HashMap.class.getName());
        }
        GraphSONUtil.writeWithType("id", property.id(), jsonGenerator, serializerProvider, typeSerializer);
        GraphSONUtil.writeWithType("value", property.value(), jsonGenerator, serializerProvider, typeSerializer);
        if (includeLabel) {
            jsonGenerator.writeStringField("label", property.label());
        }
        GraphSONSerializersV1d0.tryWriteMetaProperties(property, jsonGenerator, serializerProvider, typeSerializer, normalize2);
        jsonGenerator.writeEndObject();
    }

    private static void tryWriteMetaProperties(VertexProperty property, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer, boolean normalize2) throws IOException {
        if (property instanceof DetachedVertexProperty) {
            if (property.properties(new String[0]).hasNext()) {
                GraphSONSerializersV1d0.writeMetaProperties(property, jsonGenerator, serializerProvider, typeSerializer, normalize2);
            }
        } else if (property.graph().features().vertex().supportsMetaProperties() && property.properties(new String[0]).hasNext()) {
            GraphSONSerializersV1d0.writeMetaProperties(property, jsonGenerator, serializerProvider, typeSerializer, normalize2);
        }
    }

    private static void writeMetaProperties(VertexProperty property, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer, boolean normalize2) throws IOException {
        Iterator metaProperties;
        jsonGenerator.writeObjectFieldStart("properties");
        if (typeSerializer != null) {
            jsonGenerator.writeStringField("@class", HashMap.class.getName());
        }
        Iterator iterator2 = metaProperties = normalize2 ? IteratorUtils.list(property.properties(new String[0]), Comparators.PROPERTY_COMPARATOR).iterator() : property.properties(new String[0]);
        while (metaProperties.hasNext()) {
            Property metaProperty = metaProperties.next();
            GraphSONUtil.writeWithType(metaProperty.key(), metaProperty.value(), jsonGenerator, serializerProvider, typeSerializer);
        }
        jsonGenerator.writeEndObject();
    }

    static final class TraversalMetricsJacksonSerializer
    extends StdSerializer<TraversalMetrics> {
        public TraversalMetricsJacksonSerializer() {
            super(TraversalMetrics.class);
        }

        @Override
        public void serialize(TraversalMetrics property, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            TraversalMetricsJacksonSerializer.serializeInternal(property, jsonGenerator);
        }

        @Override
        public void serializeWithType(TraversalMetrics property, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
            TraversalMetricsJacksonSerializer.serializeInternal(property, jsonGenerator);
        }

        private static void serializeInternal(TraversalMetrics traversalMetrics, JsonGenerator jsonGenerator) throws IOException {
            HashMap<String, Serializable> m = new HashMap<String, Serializable>();
            m.put("dur", Double.valueOf((double)traversalMetrics.getDuration(TimeUnit.NANOSECONDS) / 1000000.0));
            ArrayList metrics = new ArrayList();
            traversalMetrics.getMetrics().forEach(it -> metrics.add(TraversalMetricsJacksonSerializer.metricsToMap(it)));
            m.put("metrics", metrics);
            jsonGenerator.writeObject(m);
        }

        private static Map<String, Object> metricsToMap(Metrics metrics) {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("id", metrics.getId());
            m.put("name", metrics.getName());
            m.put("counts", metrics.getCounts());
            m.put("dur", (double)metrics.getDuration(TimeUnit.NANOSECONDS) / 1000000.0);
            if (!metrics.getAnnotations().isEmpty()) {
                m.put("annotations", metrics.getAnnotations());
            }
            if (!metrics.getNested().isEmpty()) {
                ArrayList nested2 = new ArrayList();
                metrics.getNested().forEach(it -> nested2.add(TraversalMetricsJacksonSerializer.metricsToMap(it)));
                m.put("metrics", nested2);
            }
            return m;
        }
    }

    static final class TraversalExplanationJacksonSerializer
    extends StdSerializer<TraversalExplanation> {
        public TraversalExplanationJacksonSerializer() {
            super(TraversalExplanation.class);
        }

        @Override
        public void serialize(TraversalExplanation traversalExplanation, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            this.ser(traversalExplanation, jsonGenerator);
        }

        @Override
        public void serializeWithType(TraversalExplanation value2, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
            this.ser(value2, gen);
        }

        public void ser(TraversalExplanation te, JsonGenerator jsonGenerator) throws IOException {
            HashMap<String, List<String>> m = new HashMap<String, List<String>>();
            m.put("original", this.getStepsAsList(te.getOriginalTraversal()));
            List<Pair<TraversalStrategy, Traversal.Admin<?, ?>>> strategyTraversals = te.getStrategyTraversals();
            ArrayList intermediates = new ArrayList();
            for (Pair<TraversalStrategy, Traversal.Admin<?, ?>> pair2 : strategyTraversals) {
                HashMap<String, Object> intermediate = new HashMap<String, Object>();
                intermediate.put("strategy", pair2.getValue0().toString());
                intermediate.put("category", pair2.getValue0().getTraversalCategory().getSimpleName());
                intermediate.put("traversal", this.getStepsAsList(pair2.getValue1()));
                intermediates.add(intermediate);
            }
            m.put("intermediate", intermediates);
            if (strategyTraversals.isEmpty()) {
                m.put("final", this.getStepsAsList(te.getOriginalTraversal()));
            } else {
                m.put("final", this.getStepsAsList(strategyTraversals.get(strategyTraversals.size() - 1).getValue1()));
            }
            jsonGenerator.writeObject(m);
        }

        private List<String> getStepsAsList(Traversal.Admin<?, ?> t) {
            ArrayList<String> steps = new ArrayList<String>();
            t.getSteps().iterator().forEachRemaining(s2 -> steps.add(s2.toString()));
            return steps;
        }
    }

    static final class GraphSONKeySerializer
    extends StdKeySerializer {
        GraphSONKeySerializer() {
        }

        @Override
        public void serialize(Object o, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            this.ser(o, jsonGenerator, serializerProvider);
        }

        @Override
        public void serializeWithType(Object o, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
            this.ser(o, jsonGenerator, serializerProvider);
        }

        private void ser(Object o, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            if (Element.class.isAssignableFrom(o.getClass())) {
                jsonGenerator.writeFieldName(((Element)o).id().toString());
            } else {
                super.serialize(o, jsonGenerator, serializerProvider);
            }
        }
    }

    static final class TreeJacksonSerializer
    extends StdSerializer<Tree> {
        public TreeJacksonSerializer() {
            super(Tree.class);
        }

        @Override
        public void serialize(Tree tree, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
            TreeJacksonSerializer.ser(tree, jsonGenerator, null);
        }

        @Override
        public void serializeWithType(Tree tree, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonProcessingException {
            TreeJacksonSerializer.ser(tree, jsonGenerator, typeSerializer);
        }

        private static void ser(Tree tree, JsonGenerator jsonGenerator, TypeSerializer typeSerializer) throws IOException {
            jsonGenerator.writeStartObject();
            if (typeSerializer != null) {
                jsonGenerator.writeStringField("@class", HashMap.class.getName());
            }
            Set set2 = tree.entrySet();
            for (Map.Entry entry2 : set2) {
                jsonGenerator.writeObjectFieldStart(((Element)entry2.getKey()).id().toString());
                if (typeSerializer != null) {
                    jsonGenerator.writeStringField("@class", HashMap.class.getName());
                }
                jsonGenerator.writeObjectField("key", entry2.getKey());
                jsonGenerator.writeObjectField("value", entry2.getValue());
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
        }
    }

    static final class PathJacksonSerializer
    extends StdSerializer<Path> {
        public PathJacksonSerializer() {
            super(Path.class);
        }

        @Override
        public void serialize(Path path, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
            PathJacksonSerializer.ser(path, jsonGenerator, null);
        }

        @Override
        public void serializeWithType(Path path, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonProcessingException {
            PathJacksonSerializer.ser(path, jsonGenerator, typeSerializer);
        }

        private static void ser(Path path, JsonGenerator jsonGenerator, TypeSerializer typeSerializer) throws IOException {
            jsonGenerator.writeStartObject();
            if (typeSerializer != null) {
                jsonGenerator.writeStringField("@class", HashMap.class.getName());
            }
            jsonGenerator.writeObjectField("labels", path.labels());
            jsonGenerator.writeObjectField("objects", path.objects());
            jsonGenerator.writeEndObject();
        }
    }

    static final class VertexJacksonSerializer
    extends StdSerializer<Vertex> {
        private final boolean normalize;

        public VertexJacksonSerializer(boolean normalize2) {
            super(Vertex.class);
            this.normalize = normalize2;
        }

        @Override
        public void serialize(Vertex vertex, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            this.ser(vertex, jsonGenerator, serializerProvider, null);
        }

        @Override
        public void serializeWithType(Vertex vertex, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
            this.ser(vertex, jsonGenerator, serializerProvider, typeSerializer);
        }

        private void ser(Vertex vertex, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
            jsonGenerator.writeStartObject();
            if (typeSerializer != null) {
                jsonGenerator.writeStringField("@class", HashMap.class.getName());
            }
            GraphSONUtil.writeWithType("id", vertex.id(), jsonGenerator, serializerProvider, typeSerializer);
            jsonGenerator.writeStringField("label", vertex.label());
            jsonGenerator.writeStringField("type", "vertex");
            this.writeProperties(vertex, jsonGenerator, serializerProvider, typeSerializer);
            jsonGenerator.writeEndObject();
        }

        private void writeProperties(Vertex vertex, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
            jsonGenerator.writeObjectFieldStart("properties");
            if (typeSerializer != null) {
                jsonGenerator.writeStringField("@class", HashMap.class.getName());
            }
            List<String> keys = this.normalize ? IteratorUtils.list(vertex.keys().iterator(), Comparator.naturalOrder()) : new ArrayList<String>(vertex.keys());
            for (String key : keys) {
                Iterator vertexProperties = this.normalize ? IteratorUtils.list(vertex.properties(key), Comparators.PROPERTY_COMPARATOR).iterator() : vertex.properties(key);
                if (!vertexProperties.hasNext()) continue;
                jsonGenerator.writeArrayFieldStart(key);
                if (typeSerializer != null) {
                    jsonGenerator.writeString(ArrayList.class.getName());
                    jsonGenerator.writeStartArray();
                }
                while (vertexProperties.hasNext()) {
                    GraphSONSerializersV1d0.serializerVertexProperty(vertexProperties.next(), jsonGenerator, serializerProvider, typeSerializer, this.normalize, false);
                }
                jsonGenerator.writeEndArray();
                if (typeSerializer == null) continue;
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
    }

    static final class EdgeJacksonSerializer
    extends StdSerializer<Edge> {
        private final boolean normalize;

        public EdgeJacksonSerializer(boolean normalize2) {
            super(Edge.class);
            this.normalize = normalize2;
        }

        @Override
        public void serialize(Edge edge, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            this.ser(edge, jsonGenerator, serializerProvider, null);
        }

        @Override
        public void serializeWithType(Edge edge, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
            this.ser(edge, jsonGenerator, serializerProvider, typeSerializer);
        }

        private void ser(Edge edge, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
            jsonGenerator.writeStartObject();
            if (typeSerializer != null) {
                jsonGenerator.writeStringField("@class", HashMap.class.getName());
            }
            GraphSONUtil.writeWithType("id", edge.id(), jsonGenerator, serializerProvider, typeSerializer);
            jsonGenerator.writeStringField("label", edge.label());
            jsonGenerator.writeStringField("type", "edge");
            jsonGenerator.writeStringField("inVLabel", edge.inVertex().label());
            jsonGenerator.writeStringField("outVLabel", edge.outVertex().label());
            GraphSONUtil.writeWithType("inV", edge.inVertex().id(), jsonGenerator, serializerProvider, typeSerializer);
            GraphSONUtil.writeWithType("outV", edge.outVertex().id(), jsonGenerator, serializerProvider, typeSerializer);
            this.writeProperties(edge, jsonGenerator, serializerProvider, typeSerializer);
            jsonGenerator.writeEndObject();
        }

        private void writeProperties(Edge edge, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
            Iterator elementProperties;
            Iterator iterator2 = elementProperties = this.normalize ? IteratorUtils.list(edge.properties(new String[0]), Comparators.PROPERTY_COMPARATOR).iterator() : edge.properties(new String[0]);
            if (elementProperties.hasNext()) {
                jsonGenerator.writeObjectFieldStart("properties");
                if (typeSerializer != null) {
                    jsonGenerator.writeStringField("@class", HashMap.class.getName());
                }
                while (elementProperties.hasNext()) {
                    Property elementProperty = elementProperties.next();
                    GraphSONUtil.writeWithType(elementProperty.key(), elementProperty.value(), jsonGenerator, serializerProvider, typeSerializer);
                }
                jsonGenerator.writeEndObject();
            }
        }
    }

    static final class PropertyJacksonSerializer
    extends StdSerializer<Property> {
        public PropertyJacksonSerializer() {
            super(Property.class);
        }

        @Override
        public void serialize(Property property, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            PropertyJacksonSerializer.ser(property, jsonGenerator, serializerProvider, null);
        }

        @Override
        public void serializeWithType(Property property, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
            PropertyJacksonSerializer.ser(property, jsonGenerator, serializerProvider, typeSerializer);
        }

        private static void ser(Property property, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
            jsonGenerator.writeStartObject();
            if (typeSerializer != null) {
                jsonGenerator.writeStringField("@class", HashMap.class.getName());
            }
            serializerProvider.defaultSerializeField("key", property.key(), jsonGenerator);
            serializerProvider.defaultSerializeField("value", property.value(), jsonGenerator);
            jsonGenerator.writeEndObject();
        }
    }

    static final class VertexPropertyJacksonSerializer
    extends StdSerializer<VertexProperty> {
        private final boolean normalize;

        public VertexPropertyJacksonSerializer(boolean normalize2) {
            super(VertexProperty.class);
            this.normalize = normalize2;
        }

        @Override
        public void serialize(VertexProperty property, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            GraphSONSerializersV1d0.serializerVertexProperty(property, jsonGenerator, serializerProvider, null, this.normalize, true);
        }

        @Override
        public void serializeWithType(VertexProperty property, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
            GraphSONSerializersV1d0.serializerVertexProperty(property, jsonGenerator, serializerProvider, typeSerializer, this.normalize, true);
        }
    }
}

