/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.graphml;

import java.util.Stack;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

final class GraphMLWriterHelper {
    private GraphMLWriterHelper() {
    }

    public static class IndentingXMLStreamWriter
    extends DelegatingXMLStreamWriter {
        private static final Object SEEN_NOTHING = new Object();
        private static final Object SEEN_ELEMENT = new Object();
        private static final Object SEEN_DATA = new Object();
        private Object state = SEEN_NOTHING;
        private Stack<Object> stateStack = new Stack();
        private String indentStep = "  ";
        private int depth = 0;

        public IndentingXMLStreamWriter(XMLStreamWriter writer) {
            super(writer);
        }

        public int getIndentStep() {
            return this.indentStep.length();
        }

        public void setIndentStep(int indentStep) {
            StringBuilder s2 = new StringBuilder();
            while (indentStep > 0) {
                s2.append(' ');
                --indentStep;
            }
            this.indentStep = s2.toString();
        }

        public void setIndentStep(String s2) {
            this.indentStep = s2;
        }

        private void onStartElement() throws XMLStreamException {
            this.stateStack.push(SEEN_ELEMENT);
            this.state = SEEN_NOTHING;
            if (this.depth > 0) {
                super.writeCharacters("\n");
            }
            this.doIndent();
            ++this.depth;
        }

        private void onEndElement() throws XMLStreamException {
            --this.depth;
            if (this.state == SEEN_ELEMENT) {
                super.writeCharacters("\n");
                this.doIndent();
            }
            this.state = this.stateStack.pop();
        }

        private void onEmptyElement() throws XMLStreamException {
            this.state = SEEN_ELEMENT;
            if (this.depth > 0) {
                super.writeCharacters("\n");
            }
            this.doIndent();
        }

        private void doIndent() throws XMLStreamException {
            if (this.depth > 0) {
                for (int i = 0; i < this.depth; ++i) {
                    super.writeCharacters(this.indentStep);
                }
            }
        }

        @Override
        public void writeStartDocument() throws XMLStreamException {
            super.writeStartDocument();
            super.writeCharacters("\n");
        }

        @Override
        public void writeStartDocument(String version) throws XMLStreamException {
            super.writeStartDocument(version);
            super.writeCharacters("\n");
        }

        @Override
        public void writeStartDocument(String encoding, String version) throws XMLStreamException {
            super.writeStartDocument(encoding, version);
            super.writeCharacters("\n");
        }

        @Override
        public void writeStartElement(String localName) throws XMLStreamException {
            this.onStartElement();
            super.writeStartElement(localName);
        }

        @Override
        public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
            this.onStartElement();
            super.writeStartElement(namespaceURI, localName);
        }

        @Override
        public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            this.onStartElement();
            super.writeStartElement(prefix, localName, namespaceURI);
        }

        @Override
        public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
            this.onEmptyElement();
            super.writeEmptyElement(namespaceURI, localName);
        }

        @Override
        public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            this.onEmptyElement();
            super.writeEmptyElement(prefix, localName, namespaceURI);
        }

        @Override
        public void writeEmptyElement(String localName) throws XMLStreamException {
            this.onEmptyElement();
            super.writeEmptyElement(localName);
        }

        @Override
        public void writeEndElement() throws XMLStreamException {
            this.onEndElement();
            super.writeEndElement();
        }

        @Override
        public void writeCharacters(String text2) throws XMLStreamException {
            this.state = SEEN_DATA;
            super.writeCharacters(text2);
        }

        @Override
        public void writeCharacters(char[] text2, int start, int len) throws XMLStreamException {
            this.state = SEEN_DATA;
            super.writeCharacters(text2, start, len);
        }

        @Override
        public void writeCData(String data2) throws XMLStreamException {
            this.state = SEEN_DATA;
            super.writeCData(data2);
        }
    }

    static abstract class DelegatingXMLStreamWriter
    implements XMLStreamWriter {
        private final XMLStreamWriter writer;

        public DelegatingXMLStreamWriter(XMLStreamWriter writer) {
            this.writer = writer;
        }

        @Override
        public void writeStartElement(String localName) throws XMLStreamException {
            this.writer.writeStartElement(localName);
        }

        @Override
        public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
            this.writer.writeStartElement(namespaceURI, localName);
        }

        @Override
        public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            this.writer.writeStartElement(prefix, localName, namespaceURI);
        }

        @Override
        public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
            this.writer.writeEmptyElement(namespaceURI, localName);
        }

        @Override
        public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            this.writer.writeEmptyElement(prefix, localName, namespaceURI);
        }

        @Override
        public void writeEmptyElement(String localName) throws XMLStreamException {
            this.writer.writeEmptyElement(localName);
        }

        @Override
        public void writeEndElement() throws XMLStreamException {
            this.writer.writeEndElement();
        }

        @Override
        public void writeEndDocument() throws XMLStreamException {
            this.writer.writeEndDocument();
        }

        @Override
        public void close() throws XMLStreamException {
            this.writer.close();
        }

        @Override
        public void flush() throws XMLStreamException {
            this.writer.flush();
        }

        @Override
        public void writeAttribute(String localName, String value2) throws XMLStreamException {
            this.writer.writeAttribute(localName, value2);
        }

        @Override
        public void writeAttribute(String prefix, String namespaceURI, String localName, String value2) throws XMLStreamException {
            this.writer.writeAttribute(prefix, namespaceURI, localName, value2);
        }

        @Override
        public void writeAttribute(String namespaceURI, String localName, String value2) throws XMLStreamException {
            this.writer.writeAttribute(namespaceURI, localName, value2);
        }

        @Override
        public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
            this.writer.writeNamespace(prefix, namespaceURI);
        }

        @Override
        public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
            this.writer.writeDefaultNamespace(namespaceURI);
        }

        @Override
        public void writeComment(String data2) throws XMLStreamException {
            this.writer.writeComment(data2);
        }

        @Override
        public void writeProcessingInstruction(String target) throws XMLStreamException {
            this.writer.writeProcessingInstruction(target);
        }

        @Override
        public void writeProcessingInstruction(String target, String data2) throws XMLStreamException {
            this.writer.writeProcessingInstruction(target, data2);
        }

        @Override
        public void writeCData(String data2) throws XMLStreamException {
            this.writer.writeCData(data2);
        }

        @Override
        public void writeDTD(String dtd) throws XMLStreamException {
            this.writer.writeDTD(dtd);
        }

        @Override
        public void writeEntityRef(String name2) throws XMLStreamException {
            this.writer.writeEntityRef(name2);
        }

        @Override
        public void writeStartDocument() throws XMLStreamException {
            this.writer.writeStartDocument();
        }

        @Override
        public void writeStartDocument(String version) throws XMLStreamException {
            this.writer.writeStartDocument(version);
        }

        @Override
        public void writeStartDocument(String encoding, String version) throws XMLStreamException {
            this.writer.writeStartDocument(encoding, version);
        }

        @Override
        public void writeCharacters(String text2) throws XMLStreamException {
            this.writer.writeCharacters(text2);
        }

        @Override
        public void writeCharacters(char[] text2, int start, int len) throws XMLStreamException {
            this.writer.writeCharacters(text2, start, len);
        }

        @Override
        public String getPrefix(String uri2) throws XMLStreamException {
            return this.writer.getPrefix(uri2);
        }

        @Override
        public void setPrefix(String prefix, String uri2) throws XMLStreamException {
            this.writer.setPrefix(prefix, uri2);
        }

        @Override
        public void setDefaultNamespace(String uri2) throws XMLStreamException {
            this.writer.setDefaultNamespace(uri2);
        }

        @Override
        public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
            this.writer.setNamespaceContext(context);
        }

        @Override
        public NamespaceContext getNamespaceContext() {
            return this.writer.getNamespaceContext();
        }

        @Override
        public Object getProperty(String name2) throws IllegalArgumentException {
            return this.writer.getProperty(name2);
        }
    }
}

