/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.graphml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.io.GraphWriter;
import org.apache.tinkerpop.gremlin.structure.io.Io;
import org.apache.tinkerpop.gremlin.structure.io.graphml.GraphMLWriterHelper;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;
import org.apache.tinkerpop.gremlin.structure.util.Comparators;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public final class GraphMLWriter
implements GraphWriter {
    private final XMLOutputFactory inputFactory = XMLOutputFactory.newInstance();
    private boolean normalize = false;
    private final Optional<Map<String, String>> vertexKeyTypes;
    private final Optional<Map<String, String>> edgeKeyTypes;
    private final Optional<String> xmlSchemaLocation;
    private final String edgeLabelKey;
    private final String vertexLabelKey;
    private Collection<String> intersection = Collections.emptySet();

    private GraphMLWriter(boolean normalize2, Map<String, String> vertexKeyTypes, Map<String, String> edgeKeyTypes, String xmlSchemaLocation, String edgeLabelKey, String vertexLabelKey) {
        this.normalize = normalize2;
        this.vertexKeyTypes = Optional.ofNullable(vertexKeyTypes);
        this.edgeKeyTypes = Optional.ofNullable(edgeKeyTypes);
        this.xmlSchemaLocation = Optional.ofNullable(xmlSchemaLocation);
        this.edgeLabelKey = edgeLabelKey;
        this.vertexLabelKey = vertexLabelKey;
    }

    @Override
    public void writeVertex(OutputStream outputStream, Vertex v, Direction direction) throws IOException {
        throw Io.Exceptions.writerFormatIsForFullGraphSerializationOnly(this.getClass());
    }

    @Override
    public void writeVertex(OutputStream outputStream, Vertex v) throws IOException {
        throw Io.Exceptions.writerFormatIsForFullGraphSerializationOnly(this.getClass());
    }

    @Override
    public void writeEdge(OutputStream outputStream, Edge e) throws IOException {
        throw Io.Exceptions.writerFormatIsForFullGraphSerializationOnly(this.getClass());
    }

    @Override
    public void writeVertices(OutputStream outputStream, Iterator<Vertex> vertexIterator, Direction direction) throws IOException {
        throw Io.Exceptions.writerFormatIsForFullGraphSerializationOnly(this.getClass());
    }

    @Override
    public void writeVertices(OutputStream outputStream, Iterator<Vertex> vertexIterator) throws IOException {
        throw Io.Exceptions.writerFormatIsForFullGraphSerializationOnly(this.getClass());
    }

    @Override
    public void writeVertexProperty(OutputStream outputStream, VertexProperty vp) throws IOException {
        throw Io.Exceptions.writerFormatIsForFullGraphSerializationOnly(this.getClass());
    }

    @Override
    public void writeProperty(OutputStream outputStream, Property p) throws IOException {
        throw Io.Exceptions.writerFormatIsForFullGraphSerializationOnly(this.getClass());
    }

    @Override
    public void writeObject(OutputStream outputStream, Object object) throws IOException {
        throw Io.Exceptions.writerFormatIsForFullGraphSerializationOnly(this.getClass());
    }

    @Override
    public void writeGraph(OutputStream outputStream, Graph g) throws IOException {
        Map identifiedVertexKeyTypes = this.vertexKeyTypes.orElseGet(() -> GraphMLWriter.determineVertexTypes(g));
        Map identifiedEdgeKeyTypes = this.edgeKeyTypes.orElseGet(() -> GraphMLWriter.determineEdgeTypes(g));
        if (identifiedEdgeKeyTypes.containsKey(this.edgeLabelKey)) {
            throw new IllegalStateException(String.format("The edgeLabelKey value of[%s] conflicts with the name of an existing property key to be included in the GraphML", this.edgeLabelKey));
        }
        if (identifiedEdgeKeyTypes.containsKey(this.edgeLabelKey)) {
            throw new IllegalStateException(String.format("The vertexLabelKey value of[%s] conflicts with the name of an existing property key to be included in the GraphML", this.vertexLabelKey));
        }
        identifiedEdgeKeyTypes.put(this.edgeLabelKey, "string");
        identifiedVertexKeyTypes.put(this.vertexLabelKey, "string");
        try {
            XMLStreamWriter writer = this.configureWriter(outputStream);
            writer.writeStartDocument();
            writer.writeStartElement("graphml");
            this.writeXmlNsAndSchema(writer);
            this.writeTypes(identifiedVertexKeyTypes, identifiedEdgeKeyTypes, writer);
            writer.writeStartElement("graph");
            writer.writeAttribute("id", "G");
            writer.writeAttribute("edgedefault", "directed");
            this.writeVertices(writer, g);
            this.writeEdges(writer, g);
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
            writer.close();
        }
        catch (XMLStreamException xse) {
            throw new IOException(xse);
        }
    }

    private XMLStreamWriter configureWriter(OutputStream outputStream) throws XMLStreamException {
        XMLStreamWriter utf8Writer = this.inputFactory.createXMLStreamWriter(outputStream, "UTF8");
        if (this.normalize) {
            GraphMLWriterHelper.IndentingXMLStreamWriter writer = new GraphMLWriterHelper.IndentingXMLStreamWriter(utf8Writer);
            writer.setIndentStep("    ");
            return writer;
        }
        return utf8Writer;
    }

    private void writeTypes(Map<String, String> identifiedVertexKeyTypes, Map<String, String> identifiedEdgeKeyTypes, XMLStreamWriter writer) throws XMLStreamException {
        Collection<String> vertexKeySet = this.getKeysAndNormalizeIfRequired(identifiedVertexKeyTypes);
        Collection<String> edgeKeySet = this.getKeysAndNormalizeIfRequired(identifiedEdgeKeyTypes);
        this.intersection = CollectionUtils.intersection(vertexKeySet, edgeKeySet);
        for (String key : vertexKeySet) {
            writer.writeStartElement("key");
            if (this.intersection.contains(key)) {
                writer.writeAttribute("id", key.concat("V"));
            } else {
                writer.writeAttribute("id", key);
            }
            writer.writeAttribute("for", "node");
            writer.writeAttribute("attr.name", key);
            writer.writeAttribute("attr.type", identifiedVertexKeyTypes.get(key));
            writer.writeEndElement();
        }
        for (String key : edgeKeySet) {
            writer.writeStartElement("key");
            if (this.intersection.contains(key)) {
                writer.writeAttribute("id", key.concat("E"));
            } else {
                writer.writeAttribute("id", key);
            }
            writer.writeAttribute("for", "edge");
            writer.writeAttribute("attr.name", key);
            writer.writeAttribute("attr.type", identifiedEdgeKeyTypes.get(key));
            writer.writeEndElement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeEdges(XMLStreamWriter writer, Graph graph) throws XMLStreamException {
        Iterator<Edge> iterator2 = graph.edges(new Object[0]);
        try {
            if (this.normalize) {
                List<Edge> edges2 = IteratorUtils.list(iterator2);
                Collections.sort(edges2, Comparators.ELEMENT_COMPARATOR);
                for (Edge edge : edges2) {
                    writer.writeStartElement("edge");
                    writer.writeAttribute("id", edge.id().toString());
                    writer.writeAttribute("source", edge.outVertex().id().toString());
                    writer.writeAttribute("target", edge.inVertex().id().toString());
                    writer.writeStartElement("data");
                    writer.writeAttribute("key", this.edgeLabelKey);
                    writer.writeCharacters(edge.label());
                    writer.writeEndElement();
                    ArrayList<String> keys = new ArrayList<String>(edge.keys());
                    Collections.sort(keys);
                    for (String key : keys) {
                        writer.writeStartElement("data");
                        if (this.intersection != null && this.intersection.contains(key)) {
                            writer.writeAttribute("key", key + "E");
                        } else {
                            writer.writeAttribute("key", key);
                        }
                        writer.writeCharacters(edge.property(key).orElse("").toString());
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
            } else {
                while (iterator2.hasNext()) {
                    Edge edge = iterator2.next();
                    writer.writeStartElement("edge");
                    writer.writeAttribute("id", edge.id().toString());
                    writer.writeAttribute("source", edge.outVertex().id().toString());
                    writer.writeAttribute("target", edge.inVertex().id().toString());
                    writer.writeStartElement("data");
                    writer.writeAttribute("key", this.edgeLabelKey);
                    writer.writeCharacters(edge.label());
                    writer.writeEndElement();
                    for (String key : edge.keys()) {
                        writer.writeStartElement("data");
                        if (this.intersection != null && this.intersection.contains(key)) {
                            writer.writeAttribute("key", key + "E");
                        } else {
                            writer.writeAttribute("key", key);
                        }
                        writer.writeCharacters(edge.property(key).orElse("").toString());
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
            }
        }
        finally {
            CloseableIterator.closeIterator(iterator2);
        }
    }

    private void writeVertices(XMLStreamWriter writer, Graph graph) throws XMLStreamException {
        Iterable<Vertex> vertices = this.getVerticesAndNormalizeIfRequired(graph);
        for (Vertex vertex : vertices) {
            writer.writeStartElement("node");
            writer.writeAttribute("id", vertex.id().toString());
            Collection<String> keys = this.getElementKeysAndNormalizeIfRequired(vertex);
            writer.writeStartElement("data");
            writer.writeAttribute("key", this.vertexLabelKey);
            writer.writeCharacters(vertex.label());
            writer.writeEndElement();
            for (String key : keys) {
                writer.writeStartElement("data");
                if (this.intersection != null && this.intersection.contains(key)) {
                    writer.writeAttribute("key", key.concat("V"));
                } else {
                    writer.writeAttribute("key", key);
                }
                VertexProperty<Object> currentValue = GraphMLWriter.getCheckedVertexProperty(vertex, key);
                writer.writeCharacters(currentValue.orElse("").toString());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private Collection<String> getElementKeysAndNormalizeIfRequired(Element element) {
        Collection<String> keys;
        if (this.normalize) {
            keys = new ArrayList();
            keys.addAll(element.keys());
            Collections.sort((List)keys);
        } else {
            keys = element.keys();
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<Vertex> getVerticesAndNormalizeIfRequired(Graph graph) {
        Iterator<Vertex> iterator2 = graph.vertices(new Object[0]);
        try {
            List<Vertex> vertices;
            if (this.normalize) {
                vertices = new ArrayList<Vertex>();
                while (iterator2.hasNext()) {
                    ((Collection)vertices).add(iterator2.next());
                }
                Collections.sort(vertices, Comparators.ELEMENT_COMPARATOR);
            } else {
                vertices = IteratorUtils.list(iterator2);
            }
            List<Vertex> list2 = vertices;
            return list2;
        }
        finally {
            CloseableIterator.closeIterator(iterator2);
        }
    }

    private Collection<String> getKeysAndNormalizeIfRequired(Map<String, String> identifiedKeyTypes) {
        Collection<String> keyset;
        if (this.normalize) {
            keyset = new ArrayList();
            keyset.addAll(identifiedKeyTypes.keySet());
            Collections.sort((List)keyset);
        } else {
            keyset = identifiedKeyTypes.keySet();
        }
        return keyset;
    }

    private void writeXmlNsAndSchema(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeAttribute("xmlns", "http://graphml.graphdrawing.org/xmlns");
        writer.writeAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        writer.writeAttribute("xsi:schemaLocation", "http://graphml.graphdrawing.org/xmlns " + this.xmlSchemaLocation.orElse("http://graphml.graphdrawing.org/xmlns/1.1/graphml.xsd"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> determineVertexTypes(Graph graph) {
        HashMap<String, String> vertexKeyTypes = new HashMap<String, String>();
        Iterator<Vertex> vertices = graph.vertices(new Object[0]);
        try {
            while (vertices.hasNext()) {
                Vertex vertex = vertices.next();
                for (String key : vertex.keys()) {
                    if (vertexKeyTypes.containsKey(key)) continue;
                    VertexProperty<Object> currentValue = GraphMLWriter.getCheckedVertexProperty(vertex, key);
                    vertexKeyTypes.put(key, GraphMLWriter.getStringType(currentValue.value()));
                }
            }
        }
        finally {
            CloseableIterator.closeIterator(vertices);
        }
        return vertexKeyTypes;
    }

    private static VertexProperty<Object> getCheckedVertexProperty(Vertex vertex, String key) {
        Iterator properties2 = vertex.properties(key);
        VertexProperty<Object> currentValue = properties2.next();
        if (properties2.hasNext()) {
            throw new IllegalStateException("Multiple properties exists for the provided key: [%s] and multi-properties are not directly supported by GraphML format");
        }
        return currentValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> determineEdgeTypes(Graph graph) {
        HashMap<String, String> edgeKeyTypes = new HashMap<String, String>();
        Iterator<Edge> edges2 = graph.edges(new Object[0]);
        try {
            while (edges2.hasNext()) {
                Edge edge = edges2.next();
                for (String key : edge.keys()) {
                    if (edgeKeyTypes.containsKey(key)) continue;
                    edgeKeyTypes.put(key, GraphMLWriter.getStringType(edge.property(key).value()));
                }
            }
        }
        finally {
            CloseableIterator.closeIterator(edges2);
        }
        return edgeKeyTypes;
    }

    private static String getStringType(Object object) {
        if (object instanceof String) {
            return "string";
        }
        if (object instanceof Integer) {
            return "int";
        }
        if (object instanceof Long) {
            return "long";
        }
        if (object instanceof Float) {
            return "float";
        }
        if (object instanceof Double) {
            return "double";
        }
        if (object instanceof Boolean) {
            return "boolean";
        }
        return "string";
    }

    public static Builder build() {
        return new Builder();
    }

    public static final class Builder
    implements GraphWriter.WriterBuilder<GraphMLWriter> {
        private boolean normalize = false;
        private Map<String, String> vertexKeyTypes = null;
        private Map<String, String> edgeKeyTypes = null;
        private String xmlSchemaLocation = null;
        private String edgeLabelKey = "labelE";
        private String vertexLabelKey = "labelV";

        private Builder() {
        }

        public Builder normalize(boolean normalize2) {
            this.normalize = normalize2;
            return this;
        }

        public Builder vertexKeyTypes(Map<String, String> vertexKeyTypes) {
            this.vertexKeyTypes = vertexKeyTypes;
            return this;
        }

        public Builder edgeKeyTypes(Map<String, String> edgeKeyTypes) {
            this.edgeKeyTypes = edgeKeyTypes;
            return this;
        }

        public Builder xmlSchemaLocation(String xmlSchemaLocation) {
            this.xmlSchemaLocation = xmlSchemaLocation;
            return this;
        }

        public Builder edgeLabelKey(String edgeLabelKey) {
            this.edgeLabelKey = edgeLabelKey;
            return this;
        }

        public Builder vertexLabelKey(String vertexLabelKey) {
            this.vertexLabelKey = vertexLabelKey;
            return this;
        }

        @Override
        public GraphMLWriter create() {
            return new GraphMLWriter(this.normalize, this.vertexKeyTypes, this.edgeKeyTypes, this.xmlSchemaLocation, this.edgeLabelKey, this.vertexLabelKey);
        }
    }
}

