/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.graphml;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.io.GraphReader;
import org.apache.tinkerpop.gremlin.structure.io.Io;
import org.apache.tinkerpop.gremlin.structure.util.Attachable;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;

public final class GraphMLReader
implements GraphReader {
    private final String edgeLabelKey;
    private final String vertexLabelKey;
    private final long batchSize;
    private final boolean strict;
    private final XMLInputFactory inputFactory;

    private GraphMLReader(Builder builder) {
        this.edgeLabelKey = builder.edgeLabelKey;
        this.batchSize = builder.batchSize;
        this.vertexLabelKey = builder.vertexLabelKey;
        this.strict = builder.strict;
        this.inputFactory = builder.inputFactory;
    }

    @Override
    public void readGraph(InputStream graphInputStream, Graph graphToWriteTo) throws IOException {
        HashMap<Object, Vertex> cache2 = new HashMap<Object, Vertex>();
        AtomicLong counter = new AtomicLong(0L);
        boolean supportsTx = graphToWriteTo.features().graph().supportsTransactions();
        Graph.Features.EdgeFeatures edgeFeatures = graphToWriteTo.features().edge();
        Graph.Features.VertexFeatures vertexFeatures = graphToWriteTo.features().vertex();
        try {
            XMLStreamReader reader = this.inputFactory.createXMLStreamReader(graphInputStream);
            HashMap<String, String> keyIdMap = new HashMap<String, String>();
            HashMap<String, String> keyTypesMaps = new HashMap<String, String>();
            String vertexId = null;
            String vertexLabel = null;
            HashMap<String, Object> vertexProps = null;
            boolean isInVertex = false;
            String edgeId = null;
            String edgeLabel = null;
            Vertex edgeInVertex = null;
            Vertex edgeOutVertex = null;
            HashMap<String, Object> edgeProps = null;
            boolean isInEdge = false;
            block18: while (reader.hasNext()) {
                String elementName;
                Integer eventType = reader.next();
                if (eventType.equals(1)) {
                    switch (elementName = reader.getName().getLocalPart()) {
                        case "key": {
                            String id = reader.getAttributeValue(null, "id");
                            String attributeName = reader.getAttributeValue(null, "attr.name");
                            String attributeType = reader.getAttributeValue(null, "attr.type");
                            keyIdMap.put(id, attributeName);
                            keyTypesMaps.put(id, attributeType);
                            break;
                        }
                        case "node": {
                            vertexId = reader.getAttributeValue(null, "id");
                            isInVertex = true;
                            vertexProps = new HashMap<String, Object>();
                            break;
                        }
                        case "edge": {
                            edgeId = reader.getAttributeValue(null, "id");
                            String vertexIdOut = reader.getAttributeValue(null, "source");
                            String vertexIdIn = reader.getAttributeValue(null, "target");
                            edgeOutVertex = GraphMLReader.findOrCreate(vertexIdOut, graphToWriteTo, vertexFeatures, cache2, false, new Object[0]);
                            edgeInVertex = GraphMLReader.findOrCreate(vertexIdIn, graphToWriteTo, vertexFeatures, cache2, false, new Object[0]);
                            if (supportsTx && counter.incrementAndGet() % this.batchSize == 0L) {
                                graphToWriteTo.tx().commit();
                            }
                            isInEdge = true;
                            edgeProps = new HashMap<String, Object>();
                            break;
                        }
                        case "data": {
                            String key = reader.getAttributeValue(null, "key");
                            String dataAttributeName = (String)keyIdMap.get(key);
                            if (dataAttributeName == null) break;
                            String value2 = reader.getElementText();
                            if (isInVertex) {
                                if (key.equals(this.vertexLabelKey)) {
                                    vertexLabel = value2;
                                    break;
                                }
                                try {
                                    vertexProps.put(dataAttributeName, GraphMLReader.typeCastValue(key, value2, keyTypesMaps));
                                    break;
                                }
                                catch (NumberFormatException nfe) {
                                    if (!this.strict) continue block18;
                                    throw nfe;
                                }
                            }
                            if (!isInEdge) break;
                            if (key.equals(this.edgeLabelKey)) {
                                edgeLabel = value2;
                                break;
                            }
                            try {
                                edgeProps.put(dataAttributeName, GraphMLReader.typeCastValue(key, value2, keyTypesMaps));
                                break;
                            }
                            catch (NumberFormatException nfe) {
                                if (!this.strict) break;
                                throw nfe;
                            }
                        }
                    }
                    continue;
                }
                if (!eventType.equals(2)) continue;
                elementName = reader.getName().getLocalPart();
                if (elementName.equals("node")) {
                    String currentVertexId = vertexId;
                    String currentVertexLabel = Optional.ofNullable(vertexLabel).orElse("vertex");
                    Object[] propsAsArray = vertexProps.entrySet().stream().flatMap(e -> Stream.of(e.getKey(), e.getValue())).toArray();
                    GraphMLReader.findOrCreate(currentVertexId, graphToWriteTo, vertexFeatures, cache2, true, ElementHelper.upsert(propsAsArray, T.label, currentVertexLabel));
                    if (supportsTx && counter.incrementAndGet() % this.batchSize == 0L) {
                        graphToWriteTo.tx().commit();
                    }
                    vertexId = null;
                    vertexLabel = null;
                    vertexProps = null;
                    isInVertex = false;
                    continue;
                }
                if (!elementName.equals("edge")) continue;
                Object[] propsAsArray = edgeProps.entrySet().stream().flatMap(e -> Stream.of(e.getKey(), e.getValue())).toArray();
                Object[] propsReady = null != edgeId && edgeFeatures.willAllowId(edgeId) ? ElementHelper.upsert(propsAsArray, T.id, edgeId) : propsAsArray;
                edgeOutVertex.addEdge(null == edgeLabel ? "edge" : edgeLabel, edgeInVertex, propsReady);
                if (supportsTx && counter.incrementAndGet() % this.batchSize == 0L) {
                    graphToWriteTo.tx().commit();
                }
                edgeId = null;
                edgeLabel = null;
                edgeOutVertex = null;
                edgeInVertex = null;
                edgeProps = null;
                isInEdge = false;
            }
            if (supportsTx) {
                graphToWriteTo.tx().commit();
            }
        }
        catch (XMLStreamException xse) {
            if (supportsTx && counter.incrementAndGet() % this.batchSize == 0L) {
                graphToWriteTo.tx().rollback();
            }
            throw new IOException(xse);
        }
    }

    @Override
    public Iterator<Vertex> readVertices(InputStream inputStream, Function<Attachable<Vertex>, Vertex> vertexAttachMethod, Function<Attachable<Edge>, Edge> edgeAttachMethod, Direction attachEdgesOfThisDirection) throws IOException {
        throw Io.Exceptions.readerFormatIsForFullGraphSerializationOnly(this.getClass());
    }

    @Override
    public Vertex readVertex(InputStream inputStream, Function<Attachable<Vertex>, Vertex> vertexAttachMethod) throws IOException {
        throw Io.Exceptions.readerFormatIsForFullGraphSerializationOnly(this.getClass());
    }

    @Override
    public Vertex readVertex(InputStream inputStream, Function<Attachable<Vertex>, Vertex> vertexAttachMethod, Function<Attachable<Edge>, Edge> edgeAttachMethod, Direction attachEdgesOfThisDirection) throws IOException {
        throw Io.Exceptions.readerFormatIsForFullGraphSerializationOnly(this.getClass());
    }

    @Override
    public Edge readEdge(InputStream inputStream, Function<Attachable<Edge>, Edge> edgeAttachMethod) throws IOException {
        throw Io.Exceptions.readerFormatIsForFullGraphSerializationOnly(this.getClass());
    }

    @Override
    public VertexProperty readVertexProperty(InputStream inputStream, Function<Attachable<VertexProperty>, VertexProperty> vertexPropertyAttachMethod) throws IOException {
        throw Io.Exceptions.readerFormatIsForFullGraphSerializationOnly(this.getClass());
    }

    @Override
    public Property readProperty(InputStream inputStream, Function<Attachable<Property>, Property> propertyAttachMethod) throws IOException {
        throw Io.Exceptions.readerFormatIsForFullGraphSerializationOnly(this.getClass());
    }

    @Override
    public <C> C readObject(InputStream inputStream, Class<? extends C> clazz2) throws IOException {
        throw Io.Exceptions.readerFormatIsForFullGraphSerializationOnly(this.getClass());
    }

    private static Vertex findOrCreate(Object id, Graph graphToWriteTo, Graph.Features.VertexFeatures features, Map<Object, Vertex> cache2, boolean asVertex, Object ... args2) {
        if (cache2.containsKey(id)) {
            if (asVertex) {
                Vertex v = cache2.get(id);
                ElementHelper.attachProperties(v, args2);
                return v;
            }
            return cache2.get(id);
        }
        Object[] argsReady = features.willAllowId(id) ? ElementHelper.upsert(args2, T.id, id) : args2;
        Vertex v = graphToWriteTo.addVertex(argsReady);
        cache2.put(id, v);
        return v;
    }

    private static Object typeCastValue(String key, String value2, Map<String, String> keyTypes) {
        String type = keyTypes.get(key);
        if (null == type || type.equals("string")) {
            return value2;
        }
        if (type.equals("float")) {
            return Float.valueOf(value2);
        }
        if (type.equals("int")) {
            return Integer.valueOf(value2);
        }
        if (type.equals("double")) {
            return Double.valueOf(value2);
        }
        if (type.equals("boolean")) {
            return Boolean.valueOf(value2);
        }
        if (type.equals("long")) {
            return Long.valueOf(value2);
        }
        return value2;
    }

    public static Builder build() {
        return new Builder();
    }

    public static final class Builder
    implements GraphReader.ReaderBuilder<GraphMLReader> {
        private String edgeLabelKey = "labelE";
        private String vertexLabelKey = "labelV";
        private boolean strict = true;
        private long batchSize = 10000L;
        private XMLInputFactory inputFactory;

        private Builder() {
        }

        public Builder strict(boolean strict) {
            this.strict = strict;
            return this;
        }

        public Builder edgeLabelKey(String edgeLabelKey) {
            this.edgeLabelKey = edgeLabelKey;
            return this;
        }

        public Builder vertexLabelKey(String vertexLabelKey) {
            this.vertexLabelKey = vertexLabelKey;
            return this;
        }

        public Builder batchSize(long batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder xmlInputFactory(XMLInputFactory inputFactory) {
            this.inputFactory = inputFactory;
            return this;
        }

        @Override
        public GraphMLReader create() {
            if (this.inputFactory == null) {
                this.inputFactory = XMLInputFactory.newInstance();
            }
            return new GraphMLReader(this);
        }
    }
}

