/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.io.IOException;
import java.time.ZoneOffset;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SimpleTypeSerializer;

public class ZoneOffsetSerializer
extends SimpleTypeSerializer<ZoneOffset> {
    public ZoneOffsetSerializer() {
        super(DataType.ZONEOFFSET);
    }

    @Override
    protected ZoneOffset readValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        return ZoneOffset.ofTotalSeconds(buffer.readInt());
    }

    @Override
    protected void writeValue(ZoneOffset value2, Buffer buffer, GraphBinaryWriter context) throws IOException {
        buffer.writeInt(value2.getTotalSeconds());
    }
}

