/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationConverter;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.TraversalStrategyProxy;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SimpleTypeSerializer;

public class TraversalStrategySerializer
extends SimpleTypeSerializer<TraversalStrategy> {
    public TraversalStrategySerializer() {
        super(DataType.TRAVERSALSTRATEGY);
    }

    @Override
    protected TraversalStrategy readValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        Class clazz2 = context.readValue(buffer, Class.class, false);
        Map config = context.readValue(buffer, Map.class, false);
        return new TraversalStrategyProxy(clazz2, new MapConfiguration(config));
    }

    @Override
    protected void writeValue(TraversalStrategy value2, Buffer buffer, GraphBinaryWriter context) throws IOException {
        context.writeValue(value2.getClass(), buffer, false);
        context.writeValue(TraversalStrategySerializer.translateToBytecode(ConfigurationConverter.getMap(value2.getConfiguration())), buffer, false);
    }

    private static Map<Object, Object> translateToBytecode(Map<Object, Object> conf) {
        LinkedHashMap<Object, Object> newConf = new LinkedHashMap<Object, Object>(conf.size());
        conf.entrySet().forEach(entry2 -> {
            if (entry2.getValue() instanceof Traversal) {
                newConf.put(entry2.getKey(), ((Traversal)entry2.getValue()).asAdmin().getBytecode());
            } else {
                newConf.put(entry2.getKey(), entry2.getValue());
            }
        });
        return newConf;
    }
}

