/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalExplanation;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SimpleTypeSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.TransformSerializer;
import org.javatuples.Pair;

public class TraversalExplanationSerializer
extends SimpleTypeSerializer<TraversalExplanation>
implements TransformSerializer<TraversalExplanation> {
    private static final String ORIGINAL = "original";
    private static final String FINAL = "final";
    private static final String INTERMEDIATE = "intermediate";
    private static final String CATEGORY = "category";
    private static final String TRAVERSAL = "traversal";
    private static final String STRATEGY = "strategy";

    public TraversalExplanationSerializer() {
        super(null);
    }

    @Override
    protected TraversalExplanation readValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        throw new IOException("A TraversalExplanation should not be read individually");
    }

    @Override
    protected void writeValue(TraversalExplanation value2, Buffer buffer, GraphBinaryWriter context) throws IOException {
        throw new IOException("A TraversalExplanation should not be written individually");
    }

    @Override
    public Object transform(TraversalExplanation value2) {
        HashMap<String, List<String>> result2 = new HashMap<String, List<String>>();
        result2.put(ORIGINAL, TraversalExplanationSerializer.getTraversalSteps(value2.getOriginalTraversal()));
        List<Pair<TraversalStrategy, Traversal.Admin<?, ?>>> strategyTraversals = value2.getStrategyTraversals();
        result2.put(INTERMEDIATE, strategyTraversals.stream().map(pair2 -> {
            HashMap<String, Object> item = new HashMap<String, Object>();
            item.put(STRATEGY, ((TraversalStrategy)pair2.getValue0()).toString());
            item.put(CATEGORY, ((TraversalStrategy)pair2.getValue0()).getTraversalCategory().getSimpleName());
            item.put(TRAVERSAL, TraversalExplanationSerializer.getTraversalSteps((Traversal.Admin)pair2.getValue1()));
            return item;
        }).collect(Collectors.toList()));
        result2.put(FINAL, TraversalExplanationSerializer.getTraversalSteps(strategyTraversals.isEmpty() ? value2.getOriginalTraversal() : strategyTraversals.get(strategyTraversals.size() - 1).getValue1()));
        return result2;
    }

    private static List<String> getTraversalSteps(Traversal.Admin<?, ?> t) {
        return t.getSteps().stream().map(Object::toString).collect(Collectors.toList());
    }
}

