/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.io.IOException;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.TypeSerializer;

public abstract class SimpleTypeSerializer<T>
implements TypeSerializer<T> {
    private final DataType dataType;

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    public SimpleTypeSerializer(DataType dataType) {
        this.dataType = dataType;
    }

    @Override
    public T read(Buffer buffer, GraphBinaryReader context) throws IOException {
        return this.readValue(buffer, context, true);
    }

    @Override
    public T readValue(Buffer buffer, GraphBinaryReader context, boolean nullable) throws IOException {
        byte valueFlag;
        if (nullable && ((valueFlag = buffer.readByte()) & 1) == 1) {
            return null;
        }
        return this.readValue(buffer, context);
    }

    protected abstract T readValue(Buffer var1, GraphBinaryReader var2) throws IOException;

    @Override
    public void write(T value2, Buffer buffer, GraphBinaryWriter context) throws IOException {
        this.writeValue(value2, buffer, context, true);
    }

    @Override
    public void writeValue(T value2, Buffer buffer, GraphBinaryWriter context, boolean nullable) throws IOException {
        if (value2 == null) {
            if (!nullable) {
                throw new IOException("Unexpected null value when nullable is false");
            }
            context.writeValueFlagNull(buffer);
            return;
        }
        if (nullable) {
            context.writeValueFlagNone(buffer);
        }
        this.writeValue(value2, buffer, context);
    }

    protected abstract void writeValue(T var1, Buffer var2, GraphBinaryWriter var3) throws IOException;
}

