/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.util.AndP;
import org.apache.tinkerpop.gremlin.process.traversal.util.ConnectiveP;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SimpleTypeSerializer;

public class PSerializer<T extends P>
extends SimpleTypeSerializer<T> {
    private final Class<T> classOfP;
    private final ConcurrentHashMap<PFunctionId, CheckedFunction> methods = new ConcurrentHashMap();

    public PSerializer(DataType typeOfP, Class<T> classOfP) {
        super(typeOfP);
        this.classOfP = classOfP;
    }

    @Override
    protected T readValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        String predicateName = context.readValue(buffer, String.class, false);
        int length = context.readValue(buffer, Integer.class, false);
        Object[] args2 = new Object[length];
        Class[] argumentClasses = new Class[length];
        for (int i = 0; i < length; ++i) {
            args2[i] = context.read(buffer);
            argumentClasses[i] = args2[i].getClass();
        }
        if ("and".equals(predicateName)) {
            return (T)((P)args2[0]).and((Predicate)((P)args2[1]));
        }
        if ("or".equals(predicateName)) {
            return (T)((P)args2[0]).or((Predicate)((P)args2[1]));
        }
        if ("not".equals(predicateName)) {
            return (T)P.not((P)args2[0]);
        }
        CheckedFunction f2 = this.getMethod(predicateName, argumentClasses);
        try {
            return (T)((P)f2.apply(args2));
        }
        catch (Exception ex) {
            throw new IOException(String.format("Can't deserialize value into the predicate: '%s'", predicateName), ex);
        }
    }

    private CheckedFunction getMethod(String predicateName, Class<?>[] argumentClasses) throws IOException {
        PFunctionId id = new PFunctionId(predicateName, argumentClasses);
        CheckedFunction<Object[], P> result2 = this.methods.get(id);
        if (result2 == null) {
            Method m;
            boolean collectionType = false;
            try {
                m = this.classOfP.getMethod(predicateName, argumentClasses);
            }
            catch (NoSuchMethodException ex0) {
                try {
                    m = this.classOfP.getMethod(predicateName, Collection.class);
                    collectionType = true;
                }
                catch (NoSuchMethodException ex1) {
                    try {
                        m = this.classOfP.getMethod(predicateName, Object.class);
                    }
                    catch (NoSuchMethodException ex2) {
                        try {
                            m = this.classOfP.getMethod(predicateName, Object.class, Object.class);
                        }
                        catch (NoSuchMethodException ex3) {
                            throw new IOException(String.format("Can't find predicate method: '%s'", predicateName), ex2);
                        }
                    }
                }
            }
            Method finalMethod = m;
            try {
                if (Modifier.isStatic(m.getModifiers())) {
                    result2 = collectionType ? args2 -> (P)finalMethod.invoke(null, Arrays.asList(args2)) : args2 -> (P)finalMethod.invoke(null, args2);
                } else {
                    if (argumentClasses.length != 2) {
                        throw new IllegalStateException(String.format("Could not determine the form of P for %s and %s", predicateName, Arrays.asList(argumentClasses)));
                    }
                    result2 = args2 -> {
                        if (!(args2[0] instanceof P) || !(args2[1] instanceof P)) {
                            throw new IllegalStateException(String.format("Could not determine the form of P for %s and %s", predicateName, Arrays.asList(args2)));
                        }
                        P firstP = (P)args2[0];
                        P secondP = (P)args2[1];
                        return (P)finalMethod.invoke((Object)firstP, secondP);
                    };
                }
                this.methods.put(id, result2);
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }
        return result2;
    }

    @Override
    protected void writeValue(T value2, Buffer buffer, GraphBinaryWriter context) throws IOException {
        boolean isConnectedP = value2 instanceof ConnectiveP;
        String predicateName = isConnectedP ? (value2 instanceof AndP ? "and" : "or") : ((P)value2).getBiPredicate().toString();
        Object args2 = isConnectedP ? ((ConnectiveP)value2).getPredicates() : ((P)value2).getValue();
        List<Object> argsAsList = args2 instanceof Collection ? new ArrayList((Collection)args2) : Collections.singletonList(args2);
        int length = argsAsList.size();
        context.writeValue(predicateName, buffer, false);
        context.writeValue(length, buffer, false);
        for (Object o : argsAsList) {
            context.write(o, buffer);
        }
    }

    class PFunctionId {
        private final String predicateName;
        private final Class<?>[] argumentClasses;

        PFunctionId(String predicateName, Class<?>[] argumentClasses) {
            this.predicateName = predicateName;
            this.argumentClasses = argumentClasses;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PFunctionId that = (PFunctionId)o;
            return this.predicateName.equals(that.predicateName) && Arrays.equals(this.argumentClasses, that.argumentClasses);
        }

        public int hashCode() {
            int result2 = Objects.hash(this.predicateName);
            result2 = 31 * result2 + Arrays.hashCode(this.argumentClasses);
            return result2;
        }
    }

    @FunctionalInterface
    static interface CheckedFunction<A, R> {
        public R apply(A var1) throws InvocationTargetException, IllegalAccessException;
    }
}

