/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.io.IOException;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SimpleTypeSerializer;

public class OffsetTimeSerializer
extends SimpleTypeSerializer<OffsetTime> {
    public OffsetTimeSerializer() {
        super(DataType.OFFSETTIME);
    }

    @Override
    protected OffsetTime readValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        LocalTime ldt = context.readValue(buffer, LocalTime.class, false);
        ZoneOffset zo = context.readValue(buffer, ZoneOffset.class, false);
        return OffsetTime.of(ldt, zo);
    }

    @Override
    protected void writeValue(OffsetTime value2, Buffer buffer, GraphBinaryWriter context) throws IOException {
        context.writeValue(value2.toLocalTime(), buffer, false);
        context.writeValue(value2.getOffset(), buffer, false);
    }
}

