/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.io.IOException;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SimpleTypeSerializer;

public class OffsetDateTimeSerializer
extends SimpleTypeSerializer<OffsetDateTime> {
    public OffsetDateTimeSerializer() {
        super(DataType.OFFSETDATETIME);
    }

    @Override
    protected OffsetDateTime readValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        LocalDateTime ldt = context.readValue(buffer, LocalDateTime.class, false);
        ZoneOffset zo = context.readValue(buffer, ZoneOffset.class, false);
        return OffsetDateTime.of(ldt, zo);
    }

    @Override
    protected void writeValue(OffsetDateTime value2, Buffer buffer, GraphBinaryWriter context) throws IOException {
        context.writeValue(value2.toLocalDateTime(), buffer, false);
        context.writeValue(value2.getOffset(), buffer, false);
    }
}

