/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.io.IOException;
import java.time.MonthDay;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SimpleTypeSerializer;

public class MonthDaySerializer
extends SimpleTypeSerializer<MonthDay> {
    public MonthDaySerializer() {
        super(DataType.MONTHDAY);
    }

    @Override
    protected MonthDay readValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        return MonthDay.of(buffer.readByte(), (int)buffer.readByte());
    }

    @Override
    protected void writeValue(MonthDay value2, Buffer buffer, GraphBinaryWriter context) throws IOException {
        buffer.writeByte(value2.getMonthValue()).writeByte(value2.getDayOfMonth());
    }
}

