/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.tinkerpop.gremlin.process.traversal.util.Metrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.MutableMetrics;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.CollectionSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SimpleTypeSerializer;

public class MetricsSerializer
extends SimpleTypeSerializer<Metrics> {
    private static final CollectionSerializer collectionSerializer = new CollectionSerializer(DataType.LIST);

    public MetricsSerializer() {
        super(DataType.METRICS);
    }

    @Override
    protected Metrics readValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        MutableMetrics result2 = new MutableMetrics(context.readValue(buffer, String.class, false), context.readValue(buffer, String.class, false));
        result2.setDuration(context.readValue(buffer, Long.class, false), TimeUnit.NANOSECONDS);
        Map counts = context.readValue(buffer, Map.class, false);
        counts.forEach(result2::setCount);
        Map annotations2 = context.readValue(buffer, Map.class, false);
        annotations2.forEach(result2::setAnnotation);
        Collection nestedMetrics = collectionSerializer.readValue(buffer, context);
        nestedMetrics.forEach(result2::addNested);
        return result2;
    }

    @Override
    protected void writeValue(Metrics value2, Buffer buffer, GraphBinaryWriter context) throws IOException {
        context.writeValue(value2.getId(), buffer, false);
        context.writeValue(value2.getName(), buffer, false);
        context.writeValue(value2.getDuration(TimeUnit.NANOSECONDS), buffer, false);
        context.writeValue(value2.getCounts(), buffer, false);
        context.writeValue(value2.getAnnotations(), buffer, false);
        collectionSerializer.writeValue(value2.getNested(), buffer, context);
    }
}

