/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SimpleTypeSerializer;

public class MapSerializer
extends SimpleTypeSerializer<Map> {
    public MapSerializer() {
        super(DataType.MAP);
    }

    @Override
    protected Map readValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        int length = buffer.readInt();
        LinkedHashMap result2 = new LinkedHashMap(length);
        for (int i = 0; i < length; ++i) {
            result2.put(context.read(buffer), context.read(buffer));
        }
        return result2;
    }

    @Override
    protected void writeValue(Map value2, Buffer buffer, GraphBinaryWriter context) throws IOException {
        buffer.writeInt(value2.size());
        for (Map.Entry entry2 : value2.entrySet()) {
            context.write(entry2.getKey(), buffer);
            context.write(entry2.getValue(), buffer);
        }
    }
}

