/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.io.IOException;
import java.time.LocalTime;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SimpleTypeSerializer;

public class LocalTimeSerializer
extends SimpleTypeSerializer<LocalTime> {
    public LocalTimeSerializer() {
        super(DataType.LOCALTIME);
    }

    @Override
    protected LocalTime readValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        return LocalTime.ofNanoOfDay(buffer.readLong());
    }

    @Override
    protected void writeValue(LocalTime value2, Buffer buffer, GraphBinaryWriter context) throws IOException {
        buffer.writeLong(value2.toNanoOfDay());
    }
}

