/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.io.IOException;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SimpleTypeSerializer;
import org.apache.tinkerpop.gremlin.util.function.Lambda;

public class LambdaSerializer
extends SimpleTypeSerializer<Lambda> {
    public LambdaSerializer() {
        super(DataType.LAMBDA);
    }

    @Override
    protected Lambda readValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        String lang = context.readValue(buffer, String.class, false);
        String script = context.readValue(buffer, String.class, false);
        int args2 = context.readValue(buffer, Integer.class, false);
        if (0 == args2) {
            return new Lambda.ZeroArgLambda(script, lang);
        }
        if (1 == args2) {
            return new Lambda.OneArgLambda(script, lang);
        }
        if (2 == args2) {
            return new Lambda.TwoArgLambda(script, lang);
        }
        return new Lambda.UnknownArgLambda(script, lang, args2);
    }

    @Override
    protected void writeValue(Lambda value2, Buffer buffer, GraphBinaryWriter context) throws IOException {
        context.writeValue(value2.getLambdaLanguage(), buffer, false);
        context.writeValue(value2.getLambdaScript(), buffer, false);
        context.writeValue(value2.getLambdaArguments(), buffer, false);
    }
}

