/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.io.IOException;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SimpleTypeSerializer;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceEdge;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceVertex;

public class EdgeSerializer
extends SimpleTypeSerializer<Edge> {
    public EdgeSerializer() {
        super(DataType.EDGE);
    }

    @Override
    protected Edge readValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        Object id = context.read(buffer);
        String label = context.readValue(buffer, String.class, false);
        ReferenceVertex inV = new ReferenceVertex(context.read(buffer), context.readValue(buffer, String.class, false));
        ReferenceVertex outV = new ReferenceVertex(context.read(buffer), context.readValue(buffer, String.class, false));
        context.read(buffer);
        context.read(buffer);
        return new ReferenceEdge(id, label, inV, outV);
    }

    @Override
    protected void writeValue(Edge value2, Buffer buffer, GraphBinaryWriter context) throws IOException {
        context.write(value2.id(), buffer);
        context.writeValue(value2.label(), buffer, false);
        context.write(value2.inVertex().id(), buffer);
        context.writeValue(value2.inVertex().label(), buffer, false);
        context.write(value2.outVertex().id(), buffer);
        context.writeValue(value2.outVertex().label(), buffer, false);
        context.write(null, buffer);
        context.write(null, buffer);
    }
}

