/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.io.IOException;
import java.time.Duration;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SimpleTypeSerializer;

public class DurationSerializer
extends SimpleTypeSerializer<Duration> {
    public DurationSerializer() {
        super(DataType.DURATION);
    }

    @Override
    protected Duration readValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        return Duration.ofSeconds(buffer.readLong(), buffer.readInt());
    }

    @Override
    protected void writeValue(Duration value2, Buffer buffer, GraphBinaryWriter context) throws IOException {
        buffer.writeLong(value2.getSeconds()).writeInt(value2.getNano());
    }
}

