/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SimpleTypeSerializer;

public class CharSerializer
extends SimpleTypeSerializer<Character> {
    public CharSerializer() {
        super(DataType.CHAR);
    }

    @Override
    protected Character readValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        byte[] byteArray;
        int firstByte = buffer.readByte() & 0xFF;
        int byteLength = 1;
        if ((firstByte & 0x80) > 0) {
            if ((firstByte & 0xF0) == 240) {
                byteLength = 4;
            } else if ((firstByte & 0xE0) == 224) {
                byteLength = 3;
            } else if ((firstByte & 0xC0) == 192) {
                byteLength = 2;
            }
        }
        if (byteLength == 1) {
            byteArray = new byte[]{(byte)firstByte};
        } else {
            byteArray = new byte[byteLength];
            byteArray[0] = (byte)firstByte;
            buffer.readBytes(byteArray, 1, byteLength - 1);
        }
        return Character.valueOf(new String(byteArray, StandardCharsets.UTF_8).charAt(0));
    }

    @Override
    protected void writeValue(Character value2, Buffer buffer, GraphBinaryWriter context) throws IOException {
        String stringValue = Character.toString(value2.charValue());
        buffer.writeBytes(stringValue.getBytes(StandardCharsets.UTF_8));
    }
}

