/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.io.IOException;
import java.util.List;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SimpleTypeSerializer;

public class ByteCodeSerializer
extends SimpleTypeSerializer<Bytecode> {
    public ByteCodeSerializer() {
        super(DataType.BYTECODE);
    }

    @Override
    protected Bytecode readValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        Bytecode result2 = new Bytecode();
        int stepsLength = buffer.readInt();
        for (int i = 0; i < stepsLength; ++i) {
            result2.addStep(context.readValue(buffer, String.class, false), ByteCodeSerializer.getInstructionArguments(buffer, context));
        }
        int sourcesLength = buffer.readInt();
        for (int i = 0; i < sourcesLength; ++i) {
            result2.addSource(context.readValue(buffer, String.class, false), ByteCodeSerializer.getInstructionArguments(buffer, context));
        }
        return result2;
    }

    private static Object[] getInstructionArguments(Buffer buffer, GraphBinaryReader context) throws IOException {
        int valuesLength = buffer.readInt();
        Object[] values2 = new Object[valuesLength];
        for (int j = 0; j < valuesLength; ++j) {
            values2[j] = context.read(buffer);
        }
        return values2;
    }

    @Override
    protected void writeValue(Bytecode value2, Buffer buffer, GraphBinaryWriter context) throws IOException {
        List<Bytecode.Instruction> steps = value2.getStepInstructions();
        List<Bytecode.Instruction> sources = value2.getSourceInstructions();
        this.writeInstructions(buffer, context, steps);
        this.writeInstructions(buffer, context, sources);
    }

    private void writeInstructions(Buffer buffer, GraphBinaryWriter context, List<Bytecode.Instruction> instructions2) throws IOException {
        context.writeValue(instructions2.size(), buffer, false);
        for (Bytecode.Instruction instruction : instructions2) {
            context.writeValue(instruction.getOperator(), buffer, false);
            ByteCodeSerializer.fillArgumentsBuffer(instruction.getArguments(), buffer, context);
        }
    }

    private static void fillArgumentsBuffer(Object[] arguments, Buffer buffer, GraphBinaryWriter context) throws IOException {
        context.writeValue(arguments.length, buffer, false);
        for (Object value2 : arguments) {
            context.write(value2, buffer);
        }
    }
}

