/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.io.IOException;
import java.util.Map;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.BulkSet;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SimpleTypeSerializer;

public class BulkSetSerializer
extends SimpleTypeSerializer<BulkSet> {
    public BulkSetSerializer() {
        super(DataType.BULKSET);
    }

    @Override
    protected BulkSet readValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        int length = buffer.readInt();
        BulkSet result2 = new BulkSet();
        for (int i = 0; i < length; ++i) {
            result2.add(context.read(buffer), buffer.readLong());
        }
        return result2;
    }

    @Override
    protected void writeValue(BulkSet value2, Buffer buffer, GraphBinaryWriter context) throws IOException {
        Map raw2 = value2.asBulk();
        buffer.writeInt(raw2.size());
        for (Object key : raw2.keySet()) {
            context.write(key, buffer);
            buffer.writeLong(value2.get(key));
        }
    }
}

