/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.io.IOException;
import java.math.BigInteger;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SimpleTypeSerializer;

public class BigIntegerSerializer
extends SimpleTypeSerializer<BigInteger> {
    public BigIntegerSerializer() {
        super(DataType.BIGINTEGER);
    }

    @Override
    protected BigInteger readValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        byte[] bigIntBytes = new byte[buffer.readInt()];
        buffer.readBytes(bigIntBytes);
        return new BigInteger(bigIntBytes);
    }

    @Override
    protected void writeValue(BigInteger value2, Buffer buffer, GraphBinaryWriter context) throws IOException {
        byte[] twosComplement = value2.toByteArray();
        buffer.writeInt(twosComplement.length).writeBytes(twosComplement);
    }
}

