/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.structure.io.Io;
import org.apache.tinkerpop.gremlin.structure.io.IoRegistry;
import org.javatuples.Pair;

public abstract class AbstractIoRegistry
implements IoRegistry {
    private final Map<Class<? extends Io>, List<Pair<Class, Object>>> registeredSerializers = new HashMap<Class<? extends Io>, List<Pair<Class, Object>>>();

    protected void register(Class<? extends Io> ioClass, Class clazz2, Object serializer) {
        if (!this.registeredSerializers.containsKey(ioClass)) {
            this.registeredSerializers.put(ioClass, new ArrayList());
        }
        this.registeredSerializers.get(ioClass).add(Pair.with(clazz2, serializer));
    }

    @Override
    public List<Pair<Class, Object>> find(Class<? extends Io> builderClass) {
        if (!this.registeredSerializers.containsKey(builderClass)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.registeredSerializers.get(builderClass).stream().collect(Collectors.toList()));
    }

    @Override
    public <S> List<Pair<Class, S>> find(Class<? extends Io> builderClass, Class<S> serializerType) {
        if (!this.registeredSerializers.containsKey(builderClass)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.registeredSerializers.get(builderClass).stream().filter(p -> serializerType.isAssignableFrom(p.getValue1().getClass())).map(p -> Pair.with(p.getValue0(), p.getValue1())).collect(Collectors.toList()));
    }
}

