/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.io.Io;
import org.apache.tinkerpop.gremlin.structure.util.FeatureDescriptor;
import org.apache.tinkerpop.gremlin.structure.util.Host;
import org.javatuples.Pair;

public interface Graph
extends AutoCloseable,
Host {
    public static final String GRAPH = "gremlin.graph";

    public Vertex addVertex(Object ... var1);

    default public Vertex addVertex(String label) {
        return this.addVertex(T.label, label);
    }

    public <C extends GraphComputer> C compute(Class<C> var1) throws IllegalArgumentException;

    public GraphComputer compute() throws IllegalArgumentException;

    default public <C extends TraversalSource> C traversal(Class<C> traversalSourceClass) {
        try {
            return (C)((TraversalSource)traversalSourceClass.getConstructor(Graph.class).newInstance(this));
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    default public GraphTraversalSource traversal() {
        return new GraphTraversalSource(this);
    }

    public Iterator<Vertex> vertices(Object ... var1);

    public Iterator<Edge> edges(Object ... var1);

    public Transaction tx();

    @Override
    public void close() throws Exception;

    @Deprecated
    default public <I extends Io> I io(Io.Builder<I> builder) {
        return (I)builder.graph(this).create();
    }

    public Variables variables();

    public Configuration configuration();

    default public Features features() {
        return new Features(){};
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Inherited
    public static @interface OptOuts {
        public OptOut[] value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Repeatable(value=OptOuts.class)
    @Inherited
    public static @interface OptOut {
        public String test();

        public String method();

        public String reason();

        public String specific() default "";

        public String[] computers() default {};
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Inherited
    public static @interface OptIns {
        public OptIn[] value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Repeatable(value=OptIns.class)
    @Inherited
    public static @interface OptIn {
        public static final String SUITE_STRUCTURE_STANDARD = "org.apache.tinkerpop.gremlin.structure.StructureStandardSuite";
        public static final String SUITE_STRUCTURE_INTEGRATE = "org.apache.tinkerpop.gremlin.structure.StructureIntegrateSuite";
        public static final String SUITE_PROCESS_COMPUTER = "org.apache.tinkerpop.gremlin.process.ProcessComputerSuite";
        public static final String SUITE_PROCESS_STANDARD = "org.apache.tinkerpop.gremlin.process.ProcessStandardSuite";

        public String value();
    }

    public static class Exceptions {
        private static final boolean debug = Boolean.parseBoolean(System.getenv().getOrDefault("gremlin.structure.debug", "false"));

        public static UnsupportedOperationException variablesNotSupported() {
            return new UnsupportedOperationException("Graph does not support graph variables");
        }

        public static UnsupportedOperationException transactionsNotSupported() {
            return new UnsupportedOperationException("Graph does not support transactions");
        }

        public static UnsupportedOperationException graphComputerNotSupported() {
            return new UnsupportedOperationException("Graph does not support graph computer");
        }

        public static IllegalArgumentException graphDoesNotSupportProvidedGraphComputer(Class graphComputerClass) {
            return new IllegalArgumentException("Graph does not support the provided graph computer: " + graphComputerClass.getSimpleName());
        }

        public static UnsupportedOperationException vertexAdditionsNotSupported() {
            return new UnsupportedOperationException("Graph does not support adding vertices");
        }

        public static IllegalArgumentException vertexWithIdAlreadyExists(Object id) {
            return new IllegalArgumentException(String.format("Vertex with id already exists: %s", id));
        }

        public static IllegalArgumentException edgeWithIdAlreadyExists(Object id) {
            return new IllegalArgumentException(String.format("Edge with id already exists: %s", id));
        }

        public static IllegalArgumentException idArgsMustBeEitherIdOrElement() {
            return new IllegalArgumentException("id arguments must be either ids or Elements");
        }

        public static IllegalArgumentException argumentCanNotBeNull(String argument2) {
            return new IllegalArgumentException(String.format("The provided argument can not be null: %s", argument2));
        }
    }

    public static interface Features {
        default public GraphFeatures graph() {
            return new GraphFeatures(){};
        }

        default public VertexFeatures vertex() {
            return new VertexFeatures(){};
        }

        default public EdgeFeatures edge() {
            return new EdgeFeatures(){};
        }

        default public boolean supports(Class<? extends FeatureSet> featureClass, String feature) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
            FeatureSet instance;
            if (featureClass.equals(GraphFeatures.class)) {
                instance = this.graph();
            } else if (featureClass.equals(VariableFeatures.class)) {
                instance = this.graph().variables();
            } else if (featureClass.equals(VertexFeatures.class)) {
                instance = this.vertex();
            } else if (featureClass.equals(VertexPropertyFeatures.class)) {
                instance = this.vertex().properties();
            } else if (featureClass.equals(EdgeFeatures.class)) {
                instance = this.edge();
            } else if (featureClass.equals(EdgePropertyFeatures.class)) {
                instance = this.edge().properties();
            } else {
                if (featureClass.equals(PropertyFeatures.class)) {
                    throw new IllegalArgumentException(String.format("Do not reference PropertyFeatures directly in tests, utilize a specific instance: %s, %s", EdgePropertyFeatures.class, VertexPropertyFeatures.class));
                }
                throw new IllegalArgumentException(String.format("Expecting featureClass to be a valid Feature instance and not %s", featureClass));
            }
            return (Boolean)featureClass.getMethod("supports" + feature, new Class[0]).invoke((Object)instance, new Object[0]);
        }

        public static interface FeatureSet {
        }

        public static interface DataTypeFeatures
        extends FeatureSet {
            public static final String FEATURE_BOOLEAN_VALUES = "BooleanValues";
            public static final String FEATURE_BYTE_VALUES = "ByteValues";
            public static final String FEATURE_DOUBLE_VALUES = "DoubleValues";
            public static final String FEATURE_FLOAT_VALUES = "FloatValues";
            public static final String FEATURE_INTEGER_VALUES = "IntegerValues";
            public static final String FEATURE_LONG_VALUES = "LongValues";
            public static final String FEATURE_MAP_VALUES = "MapValues";
            public static final String FEATURE_MIXED_LIST_VALUES = "MixedListValues";
            public static final String FEATURE_BOOLEAN_ARRAY_VALUES = "BooleanArrayValues";
            public static final String FEATURE_BYTE_ARRAY_VALUES = "ByteArrayValues";
            public static final String FEATURE_DOUBLE_ARRAY_VALUES = "DoubleArrayValues";
            public static final String FEATURE_FLOAT_ARRAY_VALUES = "FloatArrayValues";
            public static final String FEATURE_INTEGER_ARRAY_VALUES = "IntegerArrayValues";
            public static final String FEATURE_LONG_ARRAY_VALUES = "LongArrayValues";
            public static final String FEATURE_SERIALIZABLE_VALUES = "SerializableValues";
            public static final String FEATURE_STRING_ARRAY_VALUES = "StringArrayValues";
            public static final String FEATURE_STRING_VALUES = "StringValues";
            public static final String FEATURE_UNIFORM_LIST_VALUES = "UniformListValues";

            @FeatureDescriptor(name="BooleanValues")
            default public boolean supportsBooleanValues() {
                return true;
            }

            @FeatureDescriptor(name="ByteValues")
            default public boolean supportsByteValues() {
                return true;
            }

            @FeatureDescriptor(name="DoubleValues")
            default public boolean supportsDoubleValues() {
                return true;
            }

            @FeatureDescriptor(name="FloatValues")
            default public boolean supportsFloatValues() {
                return true;
            }

            @FeatureDescriptor(name="IntegerValues")
            default public boolean supportsIntegerValues() {
                return true;
            }

            @FeatureDescriptor(name="LongValues")
            default public boolean supportsLongValues() {
                return true;
            }

            @FeatureDescriptor(name="MapValues")
            default public boolean supportsMapValues() {
                return true;
            }

            @FeatureDescriptor(name="MixedListValues")
            default public boolean supportsMixedListValues() {
                return true;
            }

            @FeatureDescriptor(name="BooleanArrayValues")
            default public boolean supportsBooleanArrayValues() {
                return true;
            }

            @FeatureDescriptor(name="ByteArrayValues")
            default public boolean supportsByteArrayValues() {
                return true;
            }

            @FeatureDescriptor(name="DoubleArrayValues")
            default public boolean supportsDoubleArrayValues() {
                return true;
            }

            @FeatureDescriptor(name="FloatArrayValues")
            default public boolean supportsFloatArrayValues() {
                return true;
            }

            @FeatureDescriptor(name="IntegerArrayValues")
            default public boolean supportsIntegerArrayValues() {
                return true;
            }

            @FeatureDescriptor(name="StringArrayValues")
            default public boolean supportsStringArrayValues() {
                return true;
            }

            @FeatureDescriptor(name="LongArrayValues")
            default public boolean supportsLongArrayValues() {
                return true;
            }

            @FeatureDescriptor(name="SerializableValues")
            default public boolean supportsSerializableValues() {
                return true;
            }

            @FeatureDescriptor(name="StringValues")
            default public boolean supportsStringValues() {
                return true;
            }

            @FeatureDescriptor(name="UniformListValues")
            default public boolean supportsUniformListValues() {
                return true;
            }
        }

        public static interface VariableFeatures
        extends DataTypeFeatures {
            public static final String FEATURE_VARIABLES = "Variables";

            @FeatureDescriptor(name="Variables")
            default public boolean supportsVariables() {
                return this.supportsBooleanValues() || this.supportsByteValues() || this.supportsDoubleValues() || this.supportsFloatValues() || this.supportsIntegerValues() || this.supportsLongValues() || this.supportsMapValues() || this.supportsMixedListValues() || this.supportsSerializableValues() || this.supportsStringValues() || this.supportsUniformListValues() || this.supportsBooleanArrayValues() || this.supportsByteArrayValues() || this.supportsDoubleArrayValues() || this.supportsFloatArrayValues() || this.supportsIntegerArrayValues() || this.supportsLongArrayValues() || this.supportsStringArrayValues();
            }
        }

        public static interface PropertyFeatures
        extends DataTypeFeatures {
            public static final String FEATURE_PROPERTIES = "Properties";

            @FeatureDescriptor(name="Properties")
            default public boolean supportsProperties() {
                return this.supportsBooleanValues() || this.supportsByteValues() || this.supportsDoubleValues() || this.supportsFloatValues() || this.supportsIntegerValues() || this.supportsLongValues() || this.supportsMapValues() || this.supportsMixedListValues() || this.supportsSerializableValues() || this.supportsStringValues() || this.supportsUniformListValues() || this.supportsBooleanArrayValues() || this.supportsByteArrayValues() || this.supportsDoubleArrayValues() || this.supportsFloatArrayValues() || this.supportsIntegerArrayValues() || this.supportsLongArrayValues() || this.supportsStringArrayValues();
            }
        }

        public static interface EdgePropertyFeatures
        extends PropertyFeatures {
        }

        public static interface VertexPropertyFeatures
        extends PropertyFeatures {
            public static final String FEATURE_REMOVE_PROPERTY = "RemoveProperty";
            public static final String FEATURE_USER_SUPPLIED_IDS = "UserSuppliedIds";
            public static final String FEATURE_NUMERIC_IDS = "NumericIds";
            public static final String FEATURE_STRING_IDS = "StringIds";
            public static final String FEATURE_UUID_IDS = "UuidIds";
            public static final String FEATURE_CUSTOM_IDS = "CustomIds";
            public static final String FEATURE_ANY_IDS = "AnyIds";

            @FeatureDescriptor(name="RemoveProperty")
            default public boolean supportsRemoveProperty() {
                return true;
            }

            @FeatureDescriptor(name="UserSuppliedIds")
            default public boolean supportsUserSuppliedIds() {
                return true;
            }

            @FeatureDescriptor(name="NumericIds")
            default public boolean supportsNumericIds() {
                return true;
            }

            @FeatureDescriptor(name="StringIds")
            default public boolean supportsStringIds() {
                return true;
            }

            @FeatureDescriptor(name="UuidIds")
            default public boolean supportsUuidIds() {
                return true;
            }

            @FeatureDescriptor(name="CustomIds")
            default public boolean supportsCustomIds() {
                return true;
            }

            @FeatureDescriptor(name="AnyIds")
            default public boolean supportsAnyIds() {
                return true;
            }

            default public boolean willAllowId(Object id) {
                if (!this.supportsUserSuppliedIds()) {
                    return false;
                }
                if (this.supportsCustomIds()) {
                    throw new UnsupportedOperationException("The default implementation is not capable of validating custom ids - please override");
                }
                return this.supportsAnyIds() || this.supportsStringIds() && id instanceof String || this.supportsNumericIds() && id instanceof Number || this.supportsUuidIds() && id instanceof UUID;
            }
        }

        public static interface ElementFeatures
        extends FeatureSet {
            public static final String FEATURE_USER_SUPPLIED_IDS = "UserSuppliedIds";
            public static final String FEATURE_NUMERIC_IDS = "NumericIds";
            public static final String FEATURE_STRING_IDS = "StringIds";
            public static final String FEATURE_UUID_IDS = "UuidIds";
            public static final String FEATURE_CUSTOM_IDS = "CustomIds";
            public static final String FEATURE_ANY_IDS = "AnyIds";
            public static final String FEATURE_ADD_PROPERTY = "AddProperty";
            public static final String FEATURE_REMOVE_PROPERTY = "RemoveProperty";

            @FeatureDescriptor(name="AddProperty")
            default public boolean supportsAddProperty() {
                return true;
            }

            @FeatureDescriptor(name="RemoveProperty")
            default public boolean supportsRemoveProperty() {
                return true;
            }

            @FeatureDescriptor(name="UserSuppliedIds")
            default public boolean supportsUserSuppliedIds() {
                return true;
            }

            @FeatureDescriptor(name="NumericIds")
            default public boolean supportsNumericIds() {
                return true;
            }

            @FeatureDescriptor(name="StringIds")
            default public boolean supportsStringIds() {
                return true;
            }

            @FeatureDescriptor(name="UuidIds")
            default public boolean supportsUuidIds() {
                return true;
            }

            @FeatureDescriptor(name="CustomIds")
            default public boolean supportsCustomIds() {
                return true;
            }

            @FeatureDescriptor(name="AnyIds")
            default public boolean supportsAnyIds() {
                return true;
            }

            default public boolean willAllowId(Object id) {
                if (!this.supportsUserSuppliedIds()) {
                    return false;
                }
                if (this.supportsCustomIds()) {
                    throw new UnsupportedOperationException("The default implementation is not capable of validating custom ids - please override");
                }
                return this.supportsAnyIds() || this.supportsStringIds() && id instanceof String || this.supportsNumericIds() && id instanceof Number || this.supportsUuidIds() && id instanceof UUID;
            }
        }

        public static interface EdgeFeatures
        extends ElementFeatures {
            public static final String FEATURE_ADD_EDGES = "AddEdges";
            public static final String FEATURE_REMOVE_EDGES = "RemoveEdges";
            public static final String FEATURE_UPSERT = "Upsert";

            @FeatureDescriptor(name="AddEdges")
            default public boolean supportsAddEdges() {
                return true;
            }

            @FeatureDescriptor(name="RemoveEdges")
            default public boolean supportsRemoveEdges() {
                return true;
            }

            @FeatureDescriptor(name="Upsert")
            default public boolean supportsUpsert() {
                return false;
            }

            default public EdgePropertyFeatures properties() {
                return new EdgePropertyFeatures(){};
            }
        }

        public static interface VertexFeatures
        extends ElementFeatures {
            public static final String FEATURE_ADD_VERTICES = "AddVertices";
            public static final String FEATURE_MULTI_PROPERTIES = "MultiProperties";
            public static final String FEATURE_DUPLICATE_MULTI_PROPERTIES = "DuplicateMultiProperties";
            public static final String FEATURE_META_PROPERTIES = "MetaProperties";
            public static final String FEATURE_REMOVE_VERTICES = "RemoveVertices";
            public static final String FEATURE_UPSERT = "Upsert";

            default public VertexProperty.Cardinality getCardinality(String key) {
                return VertexProperty.Cardinality.list;
            }

            @FeatureDescriptor(name="AddVertices")
            default public boolean supportsAddVertices() {
                return true;
            }

            @FeatureDescriptor(name="RemoveVertices")
            default public boolean supportsRemoveVertices() {
                return true;
            }

            @FeatureDescriptor(name="MultiProperties")
            default public boolean supportsMultiProperties() {
                return true;
            }

            @FeatureDescriptor(name="DuplicateMultiProperties")
            default public boolean supportsDuplicateMultiProperties() {
                return this.supportsMultiProperties();
            }

            @FeatureDescriptor(name="MetaProperties")
            default public boolean supportsMetaProperties() {
                return true;
            }

            @FeatureDescriptor(name="Upsert")
            default public boolean supportsUpsert() {
                return false;
            }

            default public VertexPropertyFeatures properties() {
                return new VertexPropertyFeatures(){};
            }
        }

        public static interface GraphFeatures
        extends FeatureSet {
            public static final String FEATURE_COMPUTER = "Computer";
            public static final String FEATURE_TRANSACTIONS = "Transactions";
            public static final String FEATURE_PERSISTENCE = "Persistence";
            public static final String FEATURE_THREADED_TRANSACTIONS = "ThreadedTransactions";
            public static final String FEATURE_CONCURRENT_ACCESS = "ConcurrentAccess";
            public static final String FEATURE_IO_READ = "IoRead";
            public static final String FEATURE_IO_WRITE = "IoWrite";

            @FeatureDescriptor(name="Computer")
            default public boolean supportsComputer() {
                return true;
            }

            @FeatureDescriptor(name="Persistence")
            default public boolean supportsPersistence() {
                return true;
            }

            @FeatureDescriptor(name="ConcurrentAccess")
            default public boolean supportsConcurrentAccess() {
                return true;
            }

            @FeatureDescriptor(name="Transactions")
            default public boolean supportsTransactions() {
                return true;
            }

            @FeatureDescriptor(name="ThreadedTransactions")
            default public boolean supportsThreadedTransactions() {
                return true;
            }

            @FeatureDescriptor(name="IoRead")
            default public boolean supportsIoRead() {
                return true;
            }

            @FeatureDescriptor(name="IoWrite")
            default public boolean supportsIoWrite() {
                return true;
            }

            default public VariableFeatures variables() {
                return new VariableFeatures(){};
            }
        }
    }

    public static interface Variables {
        public Set<String> keys();

        public <R> Optional<R> get(String var1);

        public void set(String var1, Object var2);

        public void remove(String var1);

        default public Map<String, Object> asMap() {
            Map<String, Object> map2 = this.keys().stream().map(key -> Pair.with(key, this.get((String)key).get())).collect(Collectors.toMap(Pair::getValue0, Pair::getValue1));
            return Collections.unmodifiableMap(map2);
        }

        public static class Exceptions {
            private Exceptions() {
            }

            public static IllegalArgumentException variableKeyCanNotBeEmpty() {
                return new IllegalArgumentException("Graph variable key can not be the empty string");
            }

            public static IllegalArgumentException variableKeyCanNotBeNull() {
                return new IllegalArgumentException("Graph variable key can not be null");
            }

            public static IllegalArgumentException variableValueCanNotBeNull() {
                return new IllegalArgumentException("Graph variable value can not be null");
            }

            public static UnsupportedOperationException dataTypeOfVariableValueNotSupported(Object val) {
                return Exceptions.dataTypeOfVariableValueNotSupported(val, null);
            }

            public static UnsupportedOperationException dataTypeOfVariableValueNotSupported(Object val, Exception rootCause) {
                return new UnsupportedOperationException(String.format("Graph variable value [%s] is of type %s is not supported", val, val.getClass()), rootCause);
            }
        }
    }

    public static class Hidden {
        private static final String HIDDEN_PREFIX = "~";
        private static final int HIDDEN_PREFIX_LENGTH = "~".length();

        public static String hide(String key) {
            return Hidden.isHidden(key) ? key : HIDDEN_PREFIX.concat(key);
        }

        public static String unHide(String key) {
            return Hidden.isHidden(key) ? key.substring(HIDDEN_PREFIX_LENGTH) : key;
        }

        public static boolean isHidden(String key) {
            return key.startsWith(HIDDEN_PREFIX);
        }
    }
}

