/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;

public final class TraversalUtil {
    private TraversalUtil() {
    }

    public static final <S, E> E apply(Traverser.Admin<S> traverser, Traversal.Admin<S, E> traversal) {
        Traverser.Admin<S> split2 = traverser.split();
        split2.setSideEffects(traversal.getSideEffects());
        split2.setBulk(1L);
        traversal.reset();
        traversal.addStart(split2);
        try {
            Object e = traversal.next();
            return e;
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("The provided traverser does not map to a value: " + split2 + "->" + traversal);
        }
        finally {
            CloseableIterator.closeIterator(traversal);
        }
    }

    public static final <S, E> Iterator<E> applyAll(Traverser.Admin<S> traverser, Traversal.Admin<S, E> traversal) {
        Traverser.Admin<S> split2 = traverser.split();
        split2.setSideEffects(traversal.getSideEffects());
        split2.setBulk(1L);
        traversal.reset();
        traversal.addStart(split2);
        return traversal;
    }

    public static final <S, E> boolean test(Traverser.Admin<S> traverser, Traversal.Admin<S, E> traversal, E end) {
        if (null == end) {
            return TraversalUtil.test(traverser, traversal);
        }
        Traverser.Admin<S> split2 = traverser.split();
        split2.setSideEffects(traversal.getSideEffects());
        split2.setBulk(1L);
        traversal.reset();
        traversal.addStart(split2);
        Step<?, E> endStep = traversal.getEndStep();
        boolean result2 = false;
        while (traversal.hasNext()) {
            if (!((Traverser.Admin)endStep.next()).get().equals(end)) continue;
            result2 = true;
            break;
        }
        CloseableIterator.closeIterator(traversal);
        return result2;
    }

    public static final <S, E> E applyNullable(Traverser.Admin<S> traverser, Traversal.Admin<S, E> traversal) {
        return (E)(null == traversal ? traverser.get() : TraversalUtil.apply(traverser, traversal));
    }

    public static final <S, E> boolean test(Traverser.Admin<S> traverser, Traversal.Admin<S, E> traversal) {
        Traverser.Admin<S> split2 = traverser.split();
        split2.setSideEffects(traversal.getSideEffects());
        split2.setBulk(1L);
        traversal.reset();
        traversal.addStart(split2);
        boolean val = traversal.hasNext();
        CloseableIterator.closeIterator(traversal);
        return val;
    }

    public static final <S, E> E apply(S start, Traversal.Admin<S, E> traversal) {
        traversal.reset();
        traversal.addStart(traversal.getTraverserGenerator().generate(start, traversal.getStartStep(), 1L));
        try {
            Object e = traversal.next();
            return e;
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("The provided start does not map to a value: " + start + "->" + traversal);
        }
        finally {
            CloseableIterator.closeIterator(traversal);
        }
    }

    public static final <S, E> Iterator<E> applyAll(S start, Traversal.Admin<S, E> traversal) {
        traversal.reset();
        traversal.addStart(traversal.getTraverserGenerator().generate(start, traversal.getStartStep(), 1L));
        return traversal;
    }

    public static final <S, E> boolean test(S start, Traversal.Admin<S, E> traversal, E end) {
        if (null == end) {
            return TraversalUtil.test(start, traversal);
        }
        traversal.reset();
        traversal.addStart(traversal.getTraverserGenerator().generate(start, traversal.getStartStep(), 1L));
        Step<?, E> endStep = traversal.getEndStep();
        boolean result2 = false;
        while (traversal.hasNext()) {
            if (!((Traverser.Admin)endStep.next()).get().equals(end)) continue;
            result2 = true;
            break;
        }
        CloseableIterator.closeIterator(traversal);
        return result2;
    }

    public static final <S, E> E applyNullable(S start, Traversal.Admin<S, E> traversal) {
        return (E)(null == traversal ? start : TraversalUtil.apply(start, traversal));
    }

    public static final <S, E> boolean test(S start, Traversal.Admin<S, E> traversal) {
        traversal.reset();
        traversal.addStart(traversal.getTraverserGenerator().generate(start, traversal.getStartStep(), 1L));
        boolean result2 = traversal.hasNext();
        CloseableIterator.closeIterator(traversal);
        return result2;
    }
}

