/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;

public final class TraversalRing<A, B>
implements Serializable,
Cloneable {
    private List<Traversal.Admin<A, B>> traversals = new ArrayList<Traversal.Admin<A, B>>();
    private int currentTraversal = -1;

    public TraversalRing(Traversal.Admin<A, B> ... traversals) {
        Collections.addAll(this.traversals, traversals);
    }

    public Traversal.Admin<A, B> next() {
        if (this.traversals.isEmpty()) {
            return null;
        }
        this.currentTraversal = (this.currentTraversal + 1) % this.traversals.size();
        return this.traversals.get(this.currentTraversal);
    }

    public boolean isEmpty() {
        return this.traversals.isEmpty();
    }

    public void reset() {
        this.currentTraversal = -1;
    }

    public int size() {
        return this.traversals.size();
    }

    public void addTraversal(Traversal.Admin<A, B> traversal) {
        this.traversals.add(traversal);
    }

    public List<Traversal.Admin<A, B>> getTraversals() {
        return Collections.unmodifiableList(this.traversals);
    }

    public String toString() {
        return this.traversals.toString();
    }

    public TraversalRing<A, B> clone() {
        try {
            TraversalRing clone2 = (TraversalRing)super.clone();
            clone2.traversals = new ArrayList<Traversal.Admin<A, B>>();
            for (Traversal.Admin<A, B> traversal : this.traversals) {
                clone2.addTraversal(traversal.clone());
            }
            return clone2;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public int hashCode() {
        int result2 = this.getClass().hashCode();
        int i = 0;
        for (Traversal.Admin<A, B> traversal : this.traversals) {
            result2 ^= Integer.rotateLeft(traversal.hashCode(), i++);
        }
        return result2;
    }
}

